% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifRanger.R
\name{mlr_learners_classif.ranger}
\alias{mlr_learners_classif.ranger}
\alias{LearnerClassifRanger}
\title{Ranger Classification Learner}
\description{
Random classification forest.
Calls \code{\link[ranger:ranger]{ranger::ranger()}} from package \CRANpkg{ranger}.
}
\section{Custom mlr3 parameters}{

\itemize{
\item \code{mtry}:
\itemize{
\item This hyperparameter can alternatively be set via our hyperparameter \code{mtry.ratio}
as \code{mtry = max(ceiling(mtry.ratio * n_features), 1)}.
Note that \code{mtry} and \code{mtry.ratio} are mutually exclusive.
}
}
}

\section{Initial parameter values}{

\itemize{
\item \code{num.threads}:
\itemize{
\item Actual default: \code{NULL}, triggering auto-detection of the number of CPUs.
\item Adjusted value: 1.
\item Reason for change: Conflicting with parallelization via \CRANpkg{future}.
}
}
}

\section{Dictionary}{

This \link[mlr3:Learner]{mlr3::Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_learners]{mlr3::mlr_learners} or with the associated sugar function \code{\link[mlr3:mlr_sugar]{mlr3::lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("classif.ranger")
lrn("classif.ranger")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{classif}
\item Predict Types: \dQuote{response}, \dQuote{prob}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{character}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{ranger}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   alpha \tab numeric \tab 0.5 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   always.split.variables \tab untyped \tab - \tab  \tab - \cr
   class.weights \tab untyped \tab NULL \tab  \tab - \cr
   holdout \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   importance \tab character \tab - \tab none, impurity, impurity_corrected, permutation \tab - \cr
   keep.inbag \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   max.depth \tab integer \tab NULL \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   min.bucket \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   min.node.size \tab integer \tab NULL \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   minprop \tab numeric \tab 0.1 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   mtry \tab integer \tab - \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   mtry.ratio \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   num.random.splits \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   node.stats \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   num.threads \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   num.trees \tab integer \tab 500 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   oob.error \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   regularization.factor \tab untyped \tab 1 \tab  \tab - \cr
   regularization.usedepth \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   replace \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   respect.unordered.factors \tab character \tab ignore \tab ignore, order, partition \tab - \cr
   sample.fraction \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   save.memory \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   scale.permutation.importance \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   se.method \tab character \tab infjack \tab jack, infjack \tab - \cr
   seed \tab integer \tab NULL \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   split.select.weights \tab untyped \tab NULL \tab  \tab - \cr
   splitrule \tab character \tab gini \tab gini, extratrees, hellinger \tab - \cr
   verbose \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   write.forest \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
}
}

\examples{
if (requireNamespace("ranger", quietly = TRUE)) {
# Define the Learner and set parameter values
learner = lrn("classif.ranger")
print(learner)

# Define a Task
task = tsk("sonar")

# Create train and test set
ids = partition(task)

# Train the learner on the training ids
learner$train(task, row_ids = ids$train)

# print the model
print(learner$model)

# importance method
if("importance" \%in\% learner$properties) print(learner$importance)

# Make predictions for the test rows
predictions = learner$predict(task, row_ids = ids$test)

# Score the predictions
predictions$score()
}
}
\references{
Wright, N. M, Ziegler, Andreas (2017).
\dQuote{ranger: A Fast Implementation of Random Forests for High Dimensional Data in C++ and R.}
\emph{Journal of Statistical Software}, \bold{77}(1), 1--17.
\doi{10.18637/jss.v077.i01}.

Breiman, Leo (2001).
\dQuote{Random Forests.}
\emph{Machine Learning}, \bold{45}(1), 5--32.
ISSN 1573-0565, \doi{10.1023/A:1010933404324}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}: \link[mlr3:mlr_learners]{mlr3::mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[mlr3:Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.nnet}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}} -> \code{LearnerClassifRanger}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClassifRanger-new}{\code{LearnerClassifRanger$new()}}
\item \href{#method-LearnerClassifRanger-importance}{\code{LearnerClassifRanger$importance()}}
\item \href{#method-LearnerClassifRanger-oob_error}{\code{LearnerClassifRanger$oob_error()}}
\item \href{#method-LearnerClassifRanger-clone}{\code{LearnerClassifRanger$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifRanger-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifRanger-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifRanger$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifRanger-importance"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifRanger-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are extracted from the model slot \code{variable.importance}.
Parameter \code{importance.mode} must be set to \code{"impurity"}, \code{"impurity_corrected"}, or
\code{"permutation"}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifRanger$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifRanger-oob_error"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifRanger-oob_error}{}}}
\subsection{Method \code{oob_error()}}{
The out-of-bag error, extracted from model slot \code{prediction.error}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifRanger$oob_error()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{numeric(1)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifRanger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifRanger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifRanger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
