% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dictionary.R
\docType{data}
\name{Dictionary}
\alias{Dictionary}
\title{Key-Value Storage}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
A key-value store for \link[R6:R6]{R6::R6} objects.
On retrieval of an object, the following applies:
\itemize{
\item If the object is a \code{R6ClassGenerator}, it is initialized with \code{new()}.
\item If the object is a function, it is called and must return an instance of a \link[R6:R6]{R6::R6} object.
\item If the object is an instance of a R6 class, it is returned as-is.
}

Default argument required for construction can be stored alongside their constructors by passing them to \code{$add()}.
}
\section{Construction}{
\preformatted{d = Dictionary$new()
}
}

\section{Methods}{

\itemize{
\item \code{get(key, ...)}\cr
(\code{character(1)}, ...) -> \code{any}\cr
Retrieves object with key \code{key} from the dictionary.
Additional arguments must be named and are passed to the constructor of the stored object.
\item \code{mget(keys, ...)}\cr
(\code{character()}, ...) -> named \code{list()}\cr
Returns objects with keys \code{keys} in a list named with \code{keys}.
Additional arguments must be named and are passed to the constructors of the stored objects.
\item \code{has(keys)}\cr
\code{character()} -> \code{logical()}\cr
Returns a logical vector with \code{TRUE} at its i-th position if the i-th key exists.
\item \code{keys(pattern = NULL)}\cr
\code{character(1)} -> \code{character()}\cr
Returns all keys which comply to the regular expression \code{pattern}.
If \code{pattern} is \code{NULL} (default), all keys are returned.
\item \code{add(key, value, ..., required_args = character())}\cr
(\code{character(1)}, \code{any}, ..., \code{character()}) -> \code{self}\cr
Adds object \code{value} to the dictionary with key \code{key}, potentially overwriting a previously stored item.
Additional arguments in \code{...} must be named and are passed as default arguments to \code{value} during construction.
The names of all additional arguments which are mandatory for construction and missing in \code{...} should be listed in \code{required_args}.
\item \code{remove(keys)}\cr
\code{character()} -> \code{self}\cr
Removes objects with keys \code{keys} from the dictionary.
\item \code{required_args(key)}\cr
(\code{character(1)}) -> \code{character()}\cr
Returns the names of arguments required to construct the object.
}
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(d)}\cr
\link{Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Converts the dictionary to a \code{\link[data.table:data.table]{data.table::data.table()}}.
}
}

\examples{
library(R6)
item1 = R6Class("Item", public = list(x = 1))
item2 = R6Class("Item", public = list(x = 2))
d = Dictionary$new()
d$add("a", item1)
d$add("b", item2)
d$add("c", item1$new())
d$keys()
d$get("a")
d$mget(c("a", "b"))
}
\concept{Dictionary}
\keyword{datasets}
