% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{oml_sugar}
\alias{oml_sugar}
\alias{oml_data}
\alias{oml_task}
\alias{oml_flow}
\alias{oml_run}
\alias{oml_collection}
\title{Syntactic Sugar for Object Construction}
\usage{
oml_data(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)

oml_task(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)

oml_flow(id, cache = cache_default(), test_server = test_server_default())

oml_run(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)

oml_collection(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)
}
\arguments{
\item{id}{(\code{integer(1)})\cr
OpenML id for the object.}

\item{cache}{(\code{logical(1)} | \code{character(1)})\cr
See field \code{cache} for an explanation of possible values.
Defaults to value of option \code{"mlr3oml.cache"}, or \code{FALSE} if not set.}

\item{parquet}{(\code{logical(1)})\cr
Whether to use parquet instead of arff.
If parquet is not available, it will fall back to arff.
Defaults to value of option \code{"mlr3oml.parquet"} or \code{FALSE} if not set.}

\item{test_server}{(\code{character(1)})\cr
Whether to use the OpenML test server (https://test.openml.org/) or public server
(https://www.openml.org/).
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\value{
(\code{\link{OMLObject}})
}
\description{
Functions to create OpenML objects. The following functions are available:
\itemize{
\item \code{oml_data()} - creates an instance of the R6 class \code{\link{OMLData}}.
\item \code{oml_task()} - creates an instance of the R6 class \code{\link{OMLTask}}.
\item \code{oml_flow()} - creates an instance of the R6 class \code{\link{OMLFlow}}.
\item \code{oml_run()} - creates an instance of the R6 class \code{\link{OMLRun}}.
\item \code{oml_collection()} - creates an instance of the R6 class \code{\link{OMLCollection}}.
}
}
