% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLTask.R
\name{oml_task}
\alias{oml_task}
\alias{OMLTask}
\title{Interface to OpenML Tasks}
\description{
This is the class for tasks served on \href{https://www.openml.org/search?type=task&sort=runs}{OpenML}.
It consists of a dataset and other meta-information such as the target variable for supervised
problems.
This object can also be constructed using the sugar function \code{\link[=otsk]{otsk()}}.
}
\section{mlr3 Integration}{

\itemize{
\item Obtain a \link[mlr3:Task]{mlr3::Task} by calling \code{as_task()}.
\item Obtain a \link[mlr3:Resampling]{mlr3::Resampling} by calling \code{as_resampling()}.
}
}

\examples{
try({
  library("mlr3")
  # Get a task from OpenML:
  otask = OMLTask$new(id = 31)
  # using sugar
  otask = otsk(id = 31)
  otask$data
  otask$target_names
  otask$feature_names

  # convert to mlr3 Task:
  task = as_task(otask)

  # get a task via tsk():
  tsk("oml", task_id = 31L)
  }, silent = TRUE)
}
\references{
Vanschoren J, van Rijn JN, Bischl B, Torgo L (2014).
\dQuote{OpenML.}
\emph{ACM SIGKDD Explorations Newsletter}, \bold{15}(2), 49--60.
\doi{10.1145/2641190.2641198}.
}
\section{Super class}{
\code{\link[mlr3oml:OMLObject]{mlr3oml::OMLObject}} -> \code{OMLTask}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{estimation_procedure}}{(\code{list()})\cr
The estimation procedure, returns \code{NULL} if none is available.}

\item{\code{task_splits}}{(\code{data.table()})\cr
A data.table containing the splits as provided by OpenML.}

\item{\code{tags}}{(\code{character()})\cr
Returns all tags of the object.}

\item{\code{parquet}}{(\code{logical(1)})\cr
Whether to use parquet.}

\item{\code{name}}{(\code{character(1)})\cr
Name of the task, extracted from the task description.}

\item{\code{task_type}}{(\code{character(1)})\cr
The OpenML task type.}

\item{\code{data_id}}{(\code{integer()})\cr
Data id, extracted from the task description.}

\item{\code{data}}{(\link{OMLData})\cr
Access to the underlying OpenML data set via a \link{OMLData} object.}

\item{\code{nrow}}{(\code{integer()})\cr
Number of rows, extracted from the \link{OMLData} object.}

\item{\code{ncol}}{(\code{integer()})\cr
Number of columns, as extracted from the \link{OMLData} object.}

\item{\code{target_names}}{(\code{character()})\cr
Name of the targets, as extracted from the OpenML task description.}

\item{\code{feature_names}}{(\code{character()})\cr
Name of the features (without targets of this \link{OMLTask}).}

\item{\code{data_name}}{(\code{character()})\cr
Name of the dataset (inferred from the task name).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OMLTask-new}{\code{OMLTask$new()}}
\item \href{#method-OMLTask-print}{\code{OMLTask$print()}}
\item \href{#method-OMLTask-clone}{\code{OMLTask$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3oml" data-topic="OMLObject" data-id="help"><a href='../../mlr3oml/html/OMLObject.html#method-OMLObject-help'><code>mlr3oml::OMLObject$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLTask-new"></a>}}
\if{latex}{\out{\hypertarget{method-OMLTask-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLTask$new(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML id for the object.}

\item{\code{cache}}{(\code{logical(1)} | \code{character(1)})\cr
See field \code{cache} for an explanation of possible values.
Defaults to value of option \code{"mlr3oml.cache"}, or \code{FALSE} if not set.}

\item{\code{parquet}}{(\code{logical(1)})\cr
Whether to use parquet instead of arff.
If parquet is not available, it will fall back to arff.
Defaults to value of option \code{"mlr3oml.parquet"} or \code{FALSE} if not set.}

\item{\code{test_server}}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLTask-print"></a>}}
\if{latex}{\out{\hypertarget{method-OMLTask-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
For a more detailed printer, convert to a \link[mlr3:Task]{mlr3::Task} via \verb{$task}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLTask$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLTask-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OMLTask-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLTask$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
