% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{chain_graphs}
\alias{chain_graphs}
\title{Chain a Series of Graphs}
\usage{
chain_graphs(graphs, in_place = FALSE)
}
\arguments{
\item{graphs}{\code{list} of (\code{\link{Graph}} | \code{\link{PipeOp}} | \code{NULL} | \code{...})\cr
List of elements which are the
\code{\link{Graph}}s to be joined. Elements must be convertible to \code{\link{Graph}} or \code{\link{PipeOp}} using \code{\link[=as_graph]{as_graph()}} and \code{\link[=as_pipeop]{as_pipeop()}}.
\code{NULL} is the neutral element of \code{\link{\%>>\%}} and skipped.}

\item{in_place}{(\code{logical(1)})\cr
Whether to try to avoid cloning the first element of \code{graphs}, similar to the difference
of \code{\link{\%>>!\%}} over \code{\link{\%>>\%}}. This can only be avoided if \code{graphs[[1]]} is already a \code{\link{Graph}}.
Beware that, if \code{chain_graphs()} fails because of id collisions, then \code{graphs[[1]]} will possibly be in an incompletely
modified state when \code{in_place} is \code{TRUE}.}
}
\value{
\code{\link{Graph}} the resulting \code{\link{Graph}}, or \code{NULL} if there are no non-null values in \code{graphs}.
}
\description{
Takes an arbitrary amount of \code{\link{Graph}}s or \code{\link{PipeOp}}s (or objects that can be automatically
converted into \code{\link{Graph}}s or \code{\link{PipeOp}}s, see \code{\link[=as_graph]{as_graph()}} and \code{\link[=as_pipeop]{as_pipeop()}}) as inputs and joins
them in a serial \code{\link{Graph}}, as if connecting them using \code{\link{\%>>\%}}.

Care is taken to avoid unnecessarily cloning of components. A call of
\code{chain_graphs(list(g1, g2, g3, g4, ...), in_place = FALSE)} is equivalent to
\code{g1 \%>>\% g2 \%>>!\% g3 \%>>!\% g4 \%>>!\% ...}.
A call of \code{chain_graphs(list(g1, g2, g3, g4, ...), in_place = FALSE)}
is equivalent to \code{g1 \%>>!\% g2 \%>>!\% g3 \%>>!\% g4 \%>>!\% ...} (differing in the
first operator being \verb{\%>>!\%} as well).
}
\seealso{
Other Graph operators: 
\code{\link{\%>>\%}()},
\code{\link{as_graph}()},
\code{\link{as_pipeop}()},
\code{\link{assert_graph}()},
\code{\link{assert_pipeop}()},
\code{\link{greplicate}()},
\code{\link{gunion}()},
\code{\link{pipeline_greplicate}()}
}
\concept{Graph operators}
