% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvRandomForestSRC.R
\name{LearnerSurvRandomForestSRC}
\alias{LearnerSurvRandomForestSRC}
\alias{mlr_learners_surv.randomForestSRC}
\title{RandomForestSRC Survival Forest Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[randomForestSRC:rfsrc]{randomForestSRC::rfsrc()}}.
\itemize{
\item distr is predicted using \code{\link[randomForestSRC:predict.rfsrc]{randomForestSRC::predict.rfsrc()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}

\code{\link[randomForestSRC:predict.rfsrc]{randomForestSRC::predict.rfsrc()}} returns both cumulative hazard function (chf) and survival function (surv)
but uses different estimators to derive these. \code{chf} uses a bootstrapped Nelson-Aalen estimator,
(Ishwaran, 2008) whereas \code{surv} uses a bootstrapped Kaplan-Meier estimator \url{https://kogalur.github.io/randomForestSRC/theory.html}.
The choice of which estimator to use is given by the extra \code{estimator} hyper-parameter,
default is \code{nelson}.
}
\section{Construction}{
\preformatted{LearnerSurvRandomForestSRC$new()
mlr_learners$get("surv.randomForestSRC")
lrn("surv.randomForestSRC")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, distr}
\item Feature Types: \verb{logical, integer, numeric, factor, ordered}
\item Packages: \CRANpkg{randomForestSRC} \CRANpkg{distr6}
}
}

\references{
Ishwaran H. and Kogalur U.B. (2019). Fast Unified Random Forests for Survival,
Regression, and Classification (RF-SRC), R package version 2.9.1.

Ishwaran H., Kogalur U.B., Blackstone E.H. and Lauer M.S. (2008). Random survival
forests. Ann. Appl. Statist. 2(3), 841--860.

Breiman, L. (2001).
Random Forests.
Machine Learning 45(1).
\doi{10.1023/A:1010933404324}.
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
