% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvObliqueRSF.R
\name{LearnerSurvObliqueRSF}
\alias{LearnerSurvObliqueRSF}
\alias{mlr_learners_surv.obliqueRSF}
\title{Oblique Random Survival Forest Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[obliqueRSF:ORSF]{obliqueRSF::ORSF()}}.
\itemize{
\item distr is predicted by \code{\link[obliqueRSF:predict.orsf]{obliqueRSF::predict.orsf()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}

Parameter \code{verbose} is set to \code{FALSE}.
}
\section{Construction}{
\preformatted{LearnerSurvObliqueRSF$new()
mlr_learners$get("surv.obliqueRSF")
lrn("surv.obliqueRSF")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, distr}
\item Feature Types: \verb{integer, numeric, factor, ordered}
\item Packages: \CRANpkg{obliqueRSF} \CRANpkg{distr6}
}
}

\references{
\cite{mlr3proba}{jaeger_2019}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
