% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_return.R
\name{.surv_return}
\alias{.surv_return}
\title{Get Survival Predict Types}
\usage{
.surv_return(
  times = NULL,
  surv = NULL,
  crank = NULL,
  lp = NULL,
  response = NULL
)
}
\arguments{
\item{times}{(\code{numeric()}) \cr Vector of survival times.}

\item{surv}{(\code{matrix()})\cr Matrix of predicted survival probabilities, rows are observations,
columns are times. Number of columns should be equal to length of \code{times}.}

\item{crank}{(\code{numeric()})\cr Relative risk/continuous ranking. Higher value is associated
with higher risk. If \code{NULL} then either set as \code{lp} if available or as the estimated
survival expectation, computed by \code{colSums(surv)}.}

\item{lp}{(\code{numeric()})\cr Predicted linear predictor, used to impute \code{crank} if \code{NULL}.}

\item{response}{(\code{numeric()})\cr Predicted survival time, passed through function without
modification.}
}
\description{
Internal helper function to easily return the correct survival predict types and to
automatically coerce a predicted survival probability matrix to a
\link[distr6:VectorDistribution]{distr6::VectorDistribution} of \link[distr6:WeightedDiscrete]{distr6::WeightedDiscrete} distributions.
}
\details{
To avoid complications caused by degenerative distributions, if \code{0} is not in \code{times}, then
this is added as the first time-point and a column of \code{1}s is bound to the left of \code{surv}.
Additionally if the final column of \code{surv} is not all \code{1}s, then an additional time is added
as \code{max(times) + 1e-3} and a column of \code{1}s is bound to the right of \code{surv}.
}
