% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_prediction_dens.R
\name{as_prediction_dens}
\alias{as_prediction_dens}
\alias{as_prediction_dens.PredictionDens}
\alias{as_prediction_dens.data.frame}
\title{Convert to a Density Prediction}
\usage{
as_prediction_dens(x, ...)

\method{as_prediction_dens}{PredictionDens}(x, ...)

\method{as_prediction_dens}{data.frame}(x, ...)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{...}{(any)\cr
Additional arguments.}
}
\value{
\link{PredictionDens}.
}
\description{
Convert object to a \link{PredictionDens}.
}
\examples{
library(mlr3)
task = tsk("precip")
learner = lrn("dens.hist")
learner$train(task)
p = learner$predict(task)

# convert to a data.table
tab = as.data.table(p)

# convert back to a Prediction
as_prediction_dens(tab)
}
