% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSpCVEnv.R
\name{mlr_resamplings_spcv_env}
\alias{mlr_resamplings_spcv_env}
\alias{ResamplingSpCVEnv}
\title{(blockCV) "Environmental blocking" resampling}
\description{
Splits data by clustering in the feature space.
See the upstream implementation at \code{blockCV::envBlock()} and
Valavi et al. (2018) for further information.
}
\details{
Useful when the dataset is supposed to be split on environmental information
which is present in features.
The method allows for a combination of multiple features for clustering.

The input of raster images directly as in \code{blockCV::envBlock()} is not
supported. See \CRANpkg{mlr3spatial} and its raster DataBackends for such
support in \CRANpkg{mlr3}.
}
\section{Parameters}{

\itemize{
\item \code{folds} (\code{integer(1)})\cr
Number of folds.
\item \code{features} (\code{character()})\cr
The features to use for clustering.
}
}

\examples{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {
  library(mlr3)
  task = tsk("ecuador")

  # Instantiate Resampling
  rcv = rsmp("spcv_env", folds = 4)
  rcv$instantiate(task)

  # Individual sets:
  rcv$train_set(1)
  rcv$test_set(1)
  intersect(rcv$train_set(1), rcv$test_set(1))

  # Internal storage:
  rcv$instance
}
}
\references{
Valavi R, Elith J, Lahoz-Monfort JJ, Guillera-Arroita G (2018).
\dQuote{blockCV: an R package for generating spatially or environmentally separated folds for k-fold cross-validation of species distribution models.}
\emph{bioRxiv}.
\doi{10.1101/357798}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingSpCVEnv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingSpCVEnv-new}{\code{ResamplingSpCVEnv$new()}}
\item \href{#method-ResamplingSpCVEnv-instantiate}{\code{ResamplingSpCVEnv$instantiate()}}
\item \href{#method-ResamplingSpCVEnv-clone}{\code{ResamplingSpCVEnv$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVEnv-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVEnv-new}{}}}
\subsection{Method \code{new()}}{
Create an "Environmental Block" resampling instance.

For a list of available arguments, please see \link[blockCV:envBlock]{blockCV::envBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVEnv$new(id = "spcv_env")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVEnv-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVEnv-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVEnv$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVEnv-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVEnv-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVEnv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
