% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingRepeatedSpCVknndm.R
\name{mlr_resamplings_repeated_spcv_knndm}
\alias{mlr_resamplings_repeated_spcv_knndm}
\alias{ResamplingRepeatedSpCVKnndm}
\title{(CAST) Repeated K-fold Nearest Neighbour Distance Matching}
\description{
This function implements the kNNDM algorithm and returns the necessary
indices to perform a k-fold NNDM CV for map validation.
}
\details{
knndm is a k-fold version of NNDM LOO CV for medium and large datasets. Brielfy, the algorithm tries to
find a k-fold configuration such that the integral of the absolute differences (Wasserstein W statistic)
between the empirical nearest neighbour distance distribution function between the test and training data during CV (Gj*),
and the empirical nearest neighbour distance distribution function between the prediction and training points (Gij),
is minimised. It does so by performing clustering of the training points' coordinates for different numbers of
clusters that range from k to N (number of observations), merging them into k final folds,
and selecting the configuration with the lowest W.

Using a projected CRS in `knndm` has large computational advantages since fast nearest neighbour search can be
done via the `FNN` package, while working with geographic coordinates requires computing the full
spherical distance matrices. As a clustering algorithm, `kmeans` can only be used for
projected CRS while `hierarchical` can work with both projected and geographical coordinates, though it requires
calculating the full distance matrix of the training points even for a projected CRS.

In order to select between clustering algorithms and number of folds `k`, different `knndm` configurations can be run
and compared, being the one with a lower W statistic the one that offers a better match. W statistics between `knndm`
runs are comparable as long as `tpoints` and `ppoints` or `modeldomain` stay the same.

Map validation using knndm should be used using `CAST::global_validation`, i.e. by stacking all out-of-sample
predictions and evaluating them all at once. The reasons behind this are 1) The resulting folds can be
unbalanced and 2) nearest neighbour functions are constructed and matched using all CV folds simultaneously.

If training data points are very clustered with respect to the prediction area and the presented knndm
configuration still show signs of Gj* > Gij, there are several things that can be tried. First, increase
the `maxp` parameter; this may help to control for strong clustering (at the cost of having unbalanced folds).
Secondly, decrease the number of final folds `k`, which may help to have larger clusters.

The `modeldomain` is a sf polygon that defines the prediction area. The function takes a regular point sample
(amount defined by `samplesize`) from the spatial extent. As an alternative use `ppoints` instead of
`modeldomain`, if you have already defined the prediction locations (e.g. raster pixel centroids).
When using either `modeldomain` or `ppoints`, we advise to plot the study area polygon and the
training/prediction points as a previous step to ensure they are aligned.
}
\section{Parameters}{

\itemize{
\item \code{folds} (\code{integer(1)})\cr
Number of folds.
\item \code{stratify}\cr
If \code{TRUE}, stratify on the target column.
}


\itemize{
\item \code{repeats} (\code{integer(1)})\cr
Number of repeats.
}
}

\examples{
library(mlr3)
library(mlr3spatial)
set.seed(42)
simarea = list(matrix(c(0, 0, 0, 100, 100, 100, 100, 0, 0, 0), ncol = 2, byrow = TRUE))
simarea = sf::st_polygon(simarea)
train_points = sf::st_sample(simarea, 1000, type = "random")
train_points = sf::st_as_sf(train_points)
train_points$target = as.factor(sample(c("TRUE", "FALSE"), 1000, replace = TRUE))
pred_points = sf::st_sample(simarea, 1000, type = "regular")

task = mlr3spatial::as_task_classif_st(sf::st_as_sf(train_points), "target", positive = "TRUE")

cv_knndm = rsmp("repeated_spcv_knndm", ppoints = pred_points, repeats = 2)
cv_knndm$instantiate(task)
#' ### Individual sets:
# cv_knndm$train_set(1)
# cv_knndm$test_set(1)
# check that no obs are in both sets
intersect(cv_knndm$train_set(1), cv_knndm$test_set(1)) # good!

# Internal storage:
# cv_knndm$instance # table
}
\references{
Linnenbrink, J., Mila, C., Ludwig, M., Meyer, H. (2023).
\dQuote{kNNDM: k-fold Nearest Neighbour Distance Matching Cross-Validation for map accuracy estimation.}
\emph{EGUsphere}, \bold{2023}, 1--16.
\doi{10.5194/egusphere-2023-1308}, \url{https://egusphere.copernicus.org/preprints/2023/egusphere-2023-1308/}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingRepeatedSpCVKnndm}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingRepeatedSpCVKnndm-new}{\code{ResamplingRepeatedSpCVKnndm$new()}}
\item \href{#method-ResamplingRepeatedSpCVKnndm-folds}{\code{ResamplingRepeatedSpCVKnndm$folds()}}
\item \href{#method-ResamplingRepeatedSpCVKnndm-repeats}{\code{ResamplingRepeatedSpCVKnndm$repeats()}}
\item \href{#method-ResamplingRepeatedSpCVKnndm-instantiate}{\code{ResamplingRepeatedSpCVKnndm$instantiate()}}
\item \href{#method-ResamplingRepeatedSpCVKnndm-clone}{\code{ResamplingRepeatedSpCVKnndm$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVKnndm-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVKnndm-new}{}}}
\subsection{Method \code{new()}}{
Create a "K-fold Nearest Neighbour Distance Matching" resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVKnndm$new(id = "repeated_spcv_knndm")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVKnndm-folds"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVKnndm-folds}{}}}
\subsection{Method \code{folds()}}{
Translates iteration numbers to fold number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVKnndm$folds(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVKnndm-repeats"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVKnndm-repeats}{}}}
\subsection{Method \code{repeats()}}{
Translates iteration numbers to repetition number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVKnndm$repeats(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVKnndm-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVKnndm-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVKnndm$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVKnndm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVKnndm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVKnndm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
