% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchLoss.R
\name{t_loss}
\alias{t_loss}
\alias{t_losses}
\title{Loss Function Quick Access}
\usage{
t_loss(.key, ...)

t_losses(.keys, ...)
}
\arguments{
\item{.key}{(\code{character(1)})\cr
Key of the object to retrieve.}

\item{...}{(any)\cr
See description of \code{\link[mlr3misc:dictionary_sugar_get]{dictionary_sugar_get}}.}

\item{.keys}{(\code{character()})\cr
The keys of the losses.}
}
\value{
A \code{\link{TorchLoss}}
}
\description{
Retrieve one or more \code{\link{TorchLoss}}es from \code{\link{mlr3torch_losses}}.
Works like \code{\link[mlr3:mlr_sugar]{mlr3::lrn()}} and \code{\link[mlr3:mlr_sugar]{mlr3::lrns()}}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
t_loss("mse", reduction = "mean")
# get the dictionary
t_loss()
\dontshow{\}) # examplesIf}
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
t_losses(c("mse", "l1"))
# get the dictionary
t_losses()
\dontshow{\}) # examplesIf}
}
\seealso{
Other Torch Descriptor: 
\code{\link{TorchCallback}},
\code{\link{TorchDescriptor}},
\code{\link{TorchLoss}},
\code{\link{TorchOptimizer}},
\code{\link{as_torch_callbacks}()},
\code{\link{as_torch_loss}()},
\code{\link{as_torch_optimizer}()},
\code{\link{mlr3torch_losses}},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_clbk}()},
\code{\link{t_opt}()}
}
\concept{Torch Descriptor}
