% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_spaces_default.R
\name{mlr_tuning_spaces_default}
\alias{mlr_tuning_spaces_default}
\alias{mlr_tuning_spaces_classif.glmnet.default}
\alias{mlr_tuning_spaces_classif.kknn.default}
\alias{mlr_tuning_spaces_classif.ranger.default}
\alias{mlr_tuning_spaces_classif.rpart.default}
\alias{mlr_tuning_spaces_classif.svm.default}
\alias{mlr_tuning_spaces_classif.xgboost.default}
\alias{mlr_tuning_spaces_regr.glmnet.default}
\alias{mlr_tuning_spaces_regr.kknn.default}
\alias{mlr_tuning_spaces_regr.ranger.default}
\alias{mlr_tuning_spaces_regr.rpart.default}
\alias{mlr_tuning_spaces_regr.svm.default}
\alias{mlr_tuning_spaces_regr.xgboost.default}
\title{Default Tuning Spaces}
\source{
Bischl B, Binder M, Lang M, Pielok T, Richter J, Coors S, Thomas J, Ullmann T, Becker M, Boulesteix A, Deng D, Lindauer M (2023).
\dQuote{Hyperparameter Optimization: Foundations, Algorithms, Best Practices and Open Challenges.}
}
\description{
Tuning spaces from the Bischl (2023) article.
}
\section{glmnet tuning space}{

\itemize{
\item s \eqn{[1e-04, 10000]}{[1e-04, 10000]} Logscale
\item alpha \eqn{[0, 1]}{[0, 1]}
}
}

\section{kknn tuning space}{

\itemize{
\item k \eqn{[1, 50]}{[1, 50]} Logscale
\item distance \eqn{[1, 5]}{[1, 5]}
\item kernel [\dQuote{rectangular}, \dQuote{optimal}, \dQuote{epanechnikov}, \dQuote{biweight}, \dQuote{triweight}, \dQuote{cos}, \dQuote{inv}, \dQuote{gaussian}, \dQuote{rank}]
}
}

\section{ranger tuning space}{

\itemize{
\item mtry.ratio \eqn{[0, 1]}{[0, 1]}
\item replace [TRUE,FALSE]
\item sample.fraction \eqn{[0.1, 1]}{[0.1, 1]}
\item num.trees \eqn{[1, 2000]}{[1, 2000]}
}
}

\section{rpart tuning space}{

\itemize{
\item minsplit \eqn{[2, 128]}{[2, 128]} Logscale
\item minbucket \eqn{[1, 64]}{[1, 64]} Logscale
\item cp \eqn{[1e-04, 0.1]}{[1e-04, 0.1]} Logscale
}
}

\section{svm tuning space}{

\itemize{
\item cost \eqn{[1e-04, 10000]}{[1e-04, 10000]} Logscale
\item kernel [\dQuote{polynomial}, \dQuote{radial}, \dQuote{sigmoid}, \dQuote{linear}]
\item degree \eqn{[2, 5]}{[2, 5]}
\item gamma \eqn{[1e-04, 10000]}{[1e-04, 10000]} Logscale
}
}

\section{xgboost tuning space}{

\itemize{
\item eta \eqn{[1e-04, 1]}{[1e-04, 1]} Logscale
\item nrounds \eqn{[1, 5000]}{[1, 5000]}
\item max_depth \eqn{[1, 20]}{[1, 20]}
\item colsample_bytree \eqn{[0.1, 1]}{[0.1, 1]}
\item colsample_bylevel \eqn{[0.1, 1]}{[0.1, 1]}
\item lambda \eqn{[0.001, 1000]}{[0.001, 1000]} Logscale
\item alpha \eqn{[0.001, 1000]}{[0.001, 1000]} Logscale
\item subsample \eqn{[0.1, 1]}{[0.1, 1]}
}
}

