% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClust.R
\name{autoplot.TaskClust}
\alias{autoplot.TaskClust}
\title{Plot for Clustering Tasks}
\usage{
\method{autoplot}{TaskClust}(object, type = "pairs", ...)
}
\arguments{
\item{object}{(\link[mlr3cluster:TaskClust]{mlr3cluster::TaskClust}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional argument, passed down to the underlying \code{geom} or plot
functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3cluster:TaskClust]{mlr3cluster::TaskClust}, depending on argument \code{type}:
\itemize{
\item \code{"pairs"}: Passes data and additional arguments down to
\code{\link[GGally:ggpairs]{GGally::ggpairs()}} (default).
}
}
\section{Theme}{

The \code{\link[=theme_mlr3]{theme_mlr3()}} and viridis color maps are applied by default to all
\code{autoplot()} methods. To change this behavior set
\code{options(mlr3.theme = FALSE)}.
}

\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3cluster)
  library(mlr3viz)

  task = mlr_tasks$get("usarrests")

  head(fortify(task))
  autoplot(task)
}
}
