% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-mlr3.R
\name{theme_mlr3}
\alias{theme_mlr3}
\title{mlr-org ggplot2 theme}
\usage{
theme_mlr3(
  base_size = 12,
  base_family = "",
  border = FALSE,
  margin = TRUE,
  legend = c("top", "bottom", "left", "right", "none"),
  x.text.angle = 0
)
}
\arguments{
\item{base_size}{\verb{[integer]}\cr
Text font size.}

\item{base_family}{\verb{[character]}\cr
Font family.}

\item{border}{\verb{[logical]}\cr
If TRUE, adds a panel border.}

\item{margin}{\verb{[logical]}\cr
If FALSE, reduces the plot margin(s).}

\item{legend}{\verb{[character]}\cr
Specifies the legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). Default is "top".}

\item{x.text.angle}{\verb{[numeric]}\cr
Rotation angle of x axis tick labels. Default value is 0.
Use 90 for vertical text.}
}
\description{
The theme is heavily influenced and partly based on \code{ggpubr::theme_pubr()}.
This theme is applied by default to all \code{autoplot()} methods in the mlr3
ecosystem.
If you do not like it and want to use the default ggplot2 theme, you can
add \code{+ theme_gray()} to the \code{autoplot()} call.
}
\examples{
library("ggplot2")
p = ggplot(mtcars, aes(x = wt, y = mpg)) +
  geom_point(aes(color = gear))

# Default plot
p

# theme_mlr3()
p + theme_mlr3()
}
