% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPO_meta.R
\name{cpoTransformParams}
\alias{cpoTransformParams}
\title{Transform CPO Hyperparameters}
\usage{
cpoTransformParams(
  cpo = NULLCPO,
  transformations = list(),
  additional.parameters = makeParamSet(),
  par.vals = list()
)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The CPO to use. Currently this may only have a single \link{OperatingType}. Default is \code{NULLCPO}.}

\item{transformations}{[named \code{list} of \code{language}]\cr
  This list is contains \code{\link[base]{expression}}s or \code{\link[base:substitute]{quote}}s
  that are evaluated in the context of the \emph{externally given} hyperparameters and
  then give the values of the internal hyperparameters. The name of each list element
  determines to what hyperparameter of \code{cpo} the result of the expression is written.

  Expressions can not depend on the results of other expressions.

  Hyperparameters of \code{cpo} named in this list are not exported by the TransformParams CPO. It is,
  however, possible to create synonymous parameters in \code{additional.parameters}.

  Default is \code{list()}.}

\item{additional.parameters}{[\code{\link[ParamHelpers:makeParamSet]{ParamSet}}]\cr
Additional parameters to create, on which expressions in \code{transformations} may depend.
They may contain the same names as \code{transformations}, but may not have names of hyperparameters
of \code{cpo} that are \emph{not} in \code{transformations}.}

\item{par.vals}{[\code{list}]\cr
Optional default values of parameters in \code{additional.parameters}. These override the ParamSet's
default values. Default is \code{list()}. These must only concern parameters in \code{additional.parameters},
not the ones in \code{cpo}.}
}
\value{
[\code{\link{CPO}}].
}
\description{
This is a \code{\link{CPOConstructor}} to be used to create a
\code{\link{CPO}}. It is called like any R function and returns
the created \code{\link{CPO}}.

Transforms hyperparameters, or establishes dependencies between them.
The \code{\link{CPO}} given to \code{cpoTransformParams} gets wrapped
inside a new \code{\link{CPO}} with different hyperparameters. The parameters
for which a transformation is given are not exported (unless also given
in \code{additional.parameters}).
}
\section{General CPO info}{

This function creates a CPO object, which can be applied to
\code{\link{Task}}s, \code{data.frame}s, \code{link{Learner}}s
and other CPO objects using the \code{\link{\%>>\%}} operator.

The parameters of this object can be changed after creation
using the function \code{\link{setHyperPars}}. The other
hyper-parameter manipulating functins, \code{\link{getHyperPars}}
and \code{\link{getParamSet}} similarly work as one expects.

If the \dQuote{id} parameter is given, the hyperparameters
will have this id as aprefix; this will, however, not change
the parameters of the creator function.
}

\section{Calling a \code{\link{CPOConstructor}}}{

CPO constructor functions are called with optional values of parameters, and additional \dQuote{special} optional values.
The special optional values are the \code{id} parameter, and the \code{affect.*} parameters. The \code{affect.*} parameters
enable the user to control which subset of a given dataset is affected. If no \code{affect.*} parameters are given, all
data features are affected by default.
}

\seealso{
Other CPOs: 
\code{\link{cpoApplyFunRegrTarget}()},
\code{\link{cpoApplyFun}()},
\code{\link{cpoAsNumeric}()},
\code{\link{cpoCache}()},
\code{\link{cpoCbind}()},
\code{\link{cpoCollapseFact}()},
\code{\link{cpoDropConstants}()},
\code{\link{cpoDummyEncode}()},
\code{\link{cpoFilterAnova}()},
\code{\link{cpoFilterCarscore}()},
\code{\link{cpoFilterChiSquared}()},
\code{\link{cpoFilterFeatures}()},
\code{\link{cpoFilterGainRatio}()},
\code{\link{cpoFilterInformationGain}()},
\code{\link{cpoFilterKruskal}()},
\code{\link{cpoFilterLinearCorrelation}()},
\code{\link{cpoFilterMrmr}()},
\code{\link{cpoFilterOneR}()},
\code{\link{cpoFilterPermutationImportance}()},
\code{\link{cpoFilterRankCorrelation}()},
\code{\link{cpoFilterRelief}()},
\code{\link{cpoFilterRfCImportance}()},
\code{\link{cpoFilterRfImportance}()},
\code{\link{cpoFilterRfSRCImportance}()},
\code{\link{cpoFilterRfSRCMinDepth}()},
\code{\link{cpoFilterSymmetricalUncertainty}()},
\code{\link{cpoFilterUnivariate}()},
\code{\link{cpoFilterVariance}()},
\code{\link{cpoFixFactors}()},
\code{\link{cpoIca}()},
\code{\link{cpoImpactEncodeClassif}()},
\code{\link{cpoImpactEncodeRegr}()},
\code{\link{cpoImputeConstant}()},
\code{\link{cpoImputeHist}()},
\code{\link{cpoImputeLearner}()},
\code{\link{cpoImputeMax}()},
\code{\link{cpoImputeMean}()},
\code{\link{cpoImputeMedian}()},
\code{\link{cpoImputeMin}()},
\code{\link{cpoImputeMode}()},
\code{\link{cpoImputeNormal}()},
\code{\link{cpoImputeUniform}()},
\code{\link{cpoImpute}()},
\code{\link{cpoLogTrafoRegr}()},
\code{\link{cpoMakeCols}()},
\code{\link{cpoMissingIndicators}()},
\code{\link{cpoModelMatrix}()},
\code{\link{cpoOversample}()},
\code{\link{cpoPca}()},
\code{\link{cpoProbEncode}()},
\code{\link{cpoQuantileBinNumerics}()},
\code{\link{cpoRegrResiduals}()},
\code{\link{cpoResponseFromSE}()},
\code{\link{cpoSample}()},
\code{\link{cpoScaleMaxAbs}()},
\code{\link{cpoScaleRange}()},
\code{\link{cpoScale}()},
\code{\link{cpoSelect}()},
\code{\link{cpoSmote}()},
\code{\link{cpoSpatialSign}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}

Other special CPOs: 
\code{\link{cpoCbind}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}
}
\concept{CPOs}
\concept{special CPOs}
