% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMBOControlMultiObj.R
\name{setMBOControlMultiObj}
\alias{setMBOControlMultiObj}
\title{Set multi-objective options.}
\usage{
setMBOControlMultiObj(control, method = NULL, ref.point.method = NULL,
  ref.point.offset = NULL, ref.point.val = NULL, parego.s = NULL,
  parego.rho = NULL, parego.use.margin.points = NULL,
  parego.sample.more.weights = NULL, parego.normalize = NULL,
  dib.indicator = NULL, mspot.select.crit = NULL)
}
\arguments{
\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{method}{[\code{character(1)}]\cr
Which multi-objective method should be used?
\dQuote{parego}: The ParEGO algorithm.
\dQuote{dib}: Direct indicator-based method. Subsumes SMS-EGO and epsilon-EGO.
\dQuote{mspot}: Directly optimizes multcrit problem where we substitute the true
objectives with model-based infill crits via an EMOA.
All methods can also propose multiple points in parallel.
Default is \dQuote{dib}.}

\item{ref.point.method}{[\code{character(1)}] \cr
Method for the determination of the reference point used for S-metric.
Currently used for \dQuote{mspot} and \dQuote{dib} with indicator \dQuote{sms}.
Possible Values are:
\dQuote{all}: In each dimension: maximum of all points + \code{ref.point.offset}.
\dQuote{front}: In each dimension: maximum of all non-dominated points + \code{ref.point.offset}
\dQuote{const}: Constant value, see \code{ref.point.val}.
Default is \dQuote{all}.}

\item{ref.point.offset}{[\code{numeric(1)}]\cr
See \code{ref.point.method}, default is 1.}

\item{ref.point.val}{[\code{numeric}]\cr
Constant value of reference point for hypervolume calculation.
Used if \code{ref.point.method = "const"}. Has to be specified in this case.}

\item{parego.s}{[\code{integer(1)}]\cr
Parameter of parego - controls the number of weighting vectors. The default
depends on \code{n.objectives} and leads to ca. 100000 different possible
weight vectors. The defaults for (2, 3, 4, 5, 6) dimensions are (100000,
450, 75, 37, 23) and 10 for higher dimensions.}

\item{parego.rho}{[\code{numeric(1)}]\cr
Parameter of parego - factor for Tchebycheff function. Default 0.05 as
suggested in parego paper.}

\item{parego.use.margin.points}{[\code{logical}]\cr
For each target function: Should the weight vector (0, ..., 0, 1, 0, ..., 0),
i.e. the weight vector with only 0 and a single 1 at the i.th position for
the i.th target function, be drawn with probability 1? Number of TRUE entries
must be less or equal to \code{propose.points}
Default is not to do this.}

\item{parego.sample.more.weights}{[\code{integer(1)}]\cr
In each iteration \code{parego.sample.more.weights} * \code{propose.points}
are sampled and the weights with maximum distance to each other are chosen.
Default is 1, if only 1 point is proposed each iteration, otherwise 5.}

\item{parego.normalize}{[\code{character}] \cr
Normalization to use. Either map the whole image space to [0, 1] (\code{standard}, the default)
or just the paretofront (\code{front}).}

\item{dib.indicator}{[\code{character(1)}]\cr
Either \dQuote{sms} (SMS-EGO like algorithm) or \dQuote{eps} (epsilon-EGO like algorithm).
Default is \dQuote{sms}.}

\item{mspot.select.crit}{[\code{\link{MBOInfillCrit}}]\cr
Which infill.crit to use in the candidate selection. After the NSGA2
proposed a set of candidates, \dQuote{propose.points} are selected via
the hypervoume contribution of this infill.crit.
Possible values are \dQuote{crit.mr} and \dQuote{crit.cb} (or any other InfillCrit generated with \code{\link{makeMBOInfillCritCB}}), default is \dQuote{crit.mr}.}
}
\value{
[\code{\link{MBOControl}}].
}
\description{
Extends MBO control object with multi-objective specific options.
}
\references{
For more information on the implemented multi-objective procedures the following
sources might be helpful:
Knowles, J.: ParEGO: A hybrid algorithm with on-line landscape
approximation for expensive multiobjective optimization problems. IEEE
Transactions on Evolutionary Computation, 10 (2006) 1, pp. 50-66

Wagner, T.; Emmerich, M.; Deutz, A.; Ponweiser, W.: On Expected-
Improvement Criteria for Model-Based Multi-Objective Optimization.
In: Proc. 11th Int. Conf. Parallel Problem Solving From Nature (PPSN
XI) - Part I, Krakow, Poland, Schaefer, R.; Cotta, C.; Kolodziej, J.;
Rudolph, G. (eds.), no. 6238 in Lecture Notes in Computer Science,
Springer, Berlin, 2010, ISBN 978-3-642-15843-8, pp. 718-727, doi:10.
1007/978-3-642-15844-5 72

Wagner, T.: Planning and Multi-Objective Optimization of Manufacturing
Processes by Means of Empirical Surrogate Models.
No. 71 in Schriftenreihe des ISF, Vulkan Verlag, Essen, 2013, ISBN
978-3-8027-8775-1

Zaefferer, M.; Bartz-Beielstein, T.; Naujoks, B.; Wagner, T.;
Emmerich, M.: A Case Study on Multi-Criteria Optimization of
an Event Detection Software under Limited Budgets. In: Proc.
7th International. Conf. Evolutionary Multi-Criterion Optimization (EMO
2013), March 19-22, Sheffield, UK, R. Purshouse; P. J. Fleming;
C. M. Fonseca; S. Greco; J. Shaw, eds., 2013, vol. 7811 of Lecture
Notes in Computer Science, ISBN 978-3-642-37139-4, pp. 756{770,
doi:10.1007/978-3-642-37140-0 56}

Jeong, S.; Obayashi, S.: Efficient global optimization (EGO) for Multi-Objective Problem and Data Mining.
In: Proc. IEEE Congress on
Evolutionary Computation (CEC 2005), Edinburgh, UK, Corne, D.;
et al. (eds.), IEEE, 2005, ISBN 0-7803-9363-5, pp. 2138-2145
}
\seealso{
Other MBOControl: \code{\link{makeMBOControl}},
  \code{\link{setMBOControlInfill}},
  \code{\link{setMBOControlMultiPoint}},
  \code{\link{setMBOControlTermination}}
}
