# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @export
#' @name loc_constant
#' @title Nonparametric smoothing
#' @param bw, double, bandwidth, between 0 and 1.
#' @param x, vector, covariates
#' @param y, matrix, response variables
#' @param db_kernel, bool, whether to use jackknife kernel, default 0
#' @return a matrix of smoothed values
#' @examples
#' n <- 800
#' p <- 3
#' t <- (1:n)/n
#' V <-  matrix(rnorm(n * p), nrow = p)
#' V3 <- loc_constant(0.2, t, V,1)
loc_constant <- function(bw, x, y, db_kernel = 0L) {
    .Call(`_mlrv_loc_constant`, bw, x, y, db_kernel)
}

#' @export
#' @name LocLinear
#' @title Local linear Regression
#' @description  Local linear estimates for time varying coefficients
#' @param bw double, bandwidth
#' @param t vector, time, 1:n/n
#' @param y vector, response series to be tested for long memory in the next step
#' @param X matrix, covariates matrix
#' @param db_kernel bool, whether to use jackknife kernel, default 0
#' @param deriv2 bool,whether to return second-order derivative, default 0
#' @param scb bool, whether to use the result for further calculation of simultaneous confidence bands.
#' @return a list of results
#' \itemize{
#' \item mu: the estimated trend
#' \item beta0: time varying coefficient
#' \item X_reg: a matrix whose j'th row is \mjseqn{x_j^T\hat{M}(t_j)}
#' \item t: 1:n/n
#' \item bw: bandwidth used
#' \item X: covariates matrix
#' \item y: response
#' \item n: sample size
#' \item p: dimension of covariates including the intercept
#' \item invM: inversion of M matrix, when scb = 1
#' }
#' @details
#' The time varying coefficients are estimated by
#' \mjsdeqn{(\hat{\boldsymbol{\beta}}_{b_{n}}(t), \hat{\boldsymbol{\beta}}_{b_{n}}^{\prime}(t)) = \mathbf{arg min}_{\eta_{0},\eta_{1}}[\sum_{i=1}^{n}\{y_{i}-\mathbf{x}_{i}^{\mathrm{T}}\eta_{0}-\mathbf{x}_{i}^{\mathrm{T}} \eta_{1}(t_{i}-t)\}^{2} \boldsymbol{K}_{b_{n}}(t_{i}-t)]}
#' where beta0 is \mjseqn{\hat{\boldsymbol{\beta}}_{b_{n}}(t)}, mu is \mjseqn{X^T \hat{\boldsymbol{\beta}}_{b_{n}}(t)}
#' @examples
#' param = list(d = -0.2, heter = 2, tvd = 0,
#'  tw = 0.8, rate = 0.1, cur = 1, center = 0.3,
#'   ma_rate =  0, cov_tw =  0.2, cov_rate = 0.1,
#'    cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
#' n = 500
#' t = (1:n)/n
#' data = Qct_reg(n, param)
#' result = LocLinear(0.2, t, data$y, data$x)
#' @references
#' Zhou, Z., & Wu, W. B. (2010). Simultaneous inference of linear models with time varying coefficients. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 72(4), 513-531.
LocLinear <- function(bw, t, y, X, db_kernel = 0L, deriv2 = 0L, scb = 0L) {
    .Call(`_mlrv_LocLinear`, bw, t, y, X, db_kernel, deriv2, scb)
}

#' @export
#' @name sim_T
#' @title bootstrap distribution
#' @description  bootstrap distribution of the gradient based structural stability test
#' @param X, matrix of covariates
#' @param t, vector of time points
#' @param sigma, a cube of long-run covariance function.
#' @param m, int value of window size
#' @param B, int, number of iteration
#' @param type, type of tests, residual-based or coefficient-based
#' @examples
#' param = list(B = 50, bw_set = c(0.15, 0.25), gcv =1, neighbour = 1, lb = 10, ub = 20, type = 0)
#' n = 300
#' data = bregress2(n, 2, 1) # time series regression model with 2 changes points
#' sigma = Heter_LRV(data$y, data$x, 3, 0.3, lrv_method = 1)
#' bootstrap = sim_T(data$x, (1:n)/n, sigma, 3, 20) ### 20 iterations
#' @return a vector of bootstrap statistics
sim_T <- function(X, t, sigma, m, B, type = 0L) {
    .Call(`_mlrv_sim_T`, X, t, sigma, m, B, type)
}

Diff1 <- function(e, X, m, tau_n = 0, ind = 2L) {
    .Call(`_mlrv_Diff1`, e, X, m, tau_n, ind)
}

DiffX <- function(X, m, tau_n = 0, ind = 2L) {
    .Call(`_mlrv_DiffX`, X, m, tau_n, ind)
}

DiffA <- function(y, X, m, tau_n = 0, ind = 2L) {
    .Call(`_mlrv_DiffA`, y, X, m, tau_n, ind)
}

#' @export
#' @name Heter_LRV
#' @title Long-run covariance matrix estimators
#' @description \loadmathjax The function provides a wide range of estimators for the long-run covariance matrix estimation in non-stationary time series with covariates.
#' @param e, vector, if the plug-in estimator is used, e should be the vector of residuals, OLS or nonparametric ones. If the difference-based debiased method is adopted, e should be the response time series, i.e., \mjseqn{y}. Specially, e should also be the response time series, i.e., \mjseqn{y}, if the plug-in estimator using the \mjseqn{\breve{\beta}}, the pilot estimator proposed in Bai and Wu (2023).
#' @param X, a matrix \mjseqn{n\times p}
#' @param m, integer, the window size.
#' @param tau_n, double, the smoothing parameter in the estimator. If tau_n is 0, a rule-of-thumb value will be automatically used.
#' @param lrv_method, the method of long-run variance estimation, lrvmethod = 0 uses the plug-in estimator in Zhou (2010), lrvmethod = 1 offers the debias difference-based estimator in Bai and Wu (2023), lrvmethod = 2 provides the plug-in estimator using the \mjseqn{\breve{\beta}}, the pilot estimator proposed in Bai and Wu (2023)
#' @param ind,  types of kernels
#' @param ncp,  1 no change points, 0 possible change points
#'* 1 Triangular \mjseqn{1-|u|}, \mjseqn{u \le 1}
#'* 2 Epanechnikov kernel \mjseqn{3/4(1-u^{2})}, \mjseqn{u \le 1}
#'* 3 Quartic \mjseqn{15/16(1-u^{2})^{2}}, \mjseqn{u \le 1}
#'* 4 Triweight \mjseqn{35/32(1-u^{2})^{3}}, \mjseqn{u \le 1}
#'* 5 Tricube  \mjseqn{70/81(1-|u|^{3})^{3}}, \mjseqn{u \le 1}
#' @param print_deg, bool, whether to print information of non-positiveness, default 0\mjseqn{n\times p}
#' @param rescale, bool, whether to use rescaling to correct the negative eigenvalues, default 0
#' @return a cube. The time-varying long-run covariance matrix \mjseqn{p \times p \times n}, where \eqn{p} is the dimension of the time series vector, and \eqn{n} is the sample size.
#' @examples
#' param = list(d = -0.2, heter = 2, tvd = 0,
#' tw = 0.8, rate = 0.1, cur = 1, center = 0.3,
#' ma_rate =  0, cov_tw =  0.2, cov_rate = 0.1,
#' cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
#' data = Qct_reg(1000, param)
#' sigma = Heter_LRV(data$y, data$x, 3, 0.3, lrv_method = 1)
#' @references
#' Bai, L., & Wu, W. (2023). Difference-based covariance matrix estimate in time series nonparametric regression with applications to specification tests.
#'
#' Zhou, Z. and Wu, W. B. (2010). Simultaneous inference of linear models with time varying coefficients.J. R. Stat. Soc. Ser. B. Stat. Methodol., 72(4):513–531.
Heter_LRV <- function(e, X, m, tau_n = 0, lrv_method = 1L, ind = 2L, print_deg = 0L, rescale = 0L, ncp = 0L) {
    .Call(`_mlrv_Heter_LRV`, e, X, m, tau_n, lrv_method, ind, print_deg, rescale, ncp)
}

sim_Phi_heter <- function(data, B, sigma, R) {
    .Call(`_mlrv_sim_Phi_heter`, data, B, sigma, R)
}

sim_Phi_heter_RS <- function(data, B, sigma, R) {
    .Call(`_mlrv_sim_Phi_heter_RS`, data, B, sigma, R)
}

sim_Phi_heter_KS <- function(data, B, sigma, R) {
    .Call(`_mlrv_sim_Phi_heter_KS`, data, B, sigma, R)
}

sim_Phi_heter_VS <- function(data, B, sigma, R) {
    .Call(`_mlrv_sim_Phi_heter_VS`, data, B, sigma, R)
}

#' @export
#' @name gcv_cov
#' @title Generalized Cross Validation
#' @description Given a bandwidth, compute its corresponding GCV value \loadmathjax
#' @param bw double, bandwidth
#' @param t vector, scaled time \mjseqn{[0,1]}
#' @param y vector, response
#' @param X matrix, covariates matrix
#' @param verbose bool, whether to print the  numerator and denominator in GCV value
#' @return GCV value
#' @examples
#' param = list(d = -0.2, heter = 2, tvd = 0,
#'  tw = 0.8, rate = 0.1, cur = 1, center = 0.3,
#'   ma_rate =  0, cov_tw =  0.2, cov_rate = 0.1,
#'    cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
#' data = Qct_reg(1000, param)
#' value <- gcv_cov(0.2, (1:1000)/1000, data$y, data$x)
#' @details
#' Generalized cross validation value is defined as
#' \mjsdeqn{n^{-1}| Y-\hat{Y}|^2/[1- \mathrm{tr}(Q(b)) / n]^2}
#' When computing \mjseqn{\mathrm{tr}(Q(b))},
#' we use the fact that the first derivative of coefficient function is zero at central point
#' The ith diagonal value of \mjseqn{Q(b)} is actually \mjseqn{x^T(t_i)S^{-1}_{n}x(t_i)}
#' where \mjseqn{S^{-1}_{n}} means the top left p-dimension square matrix of
#'  \mjseqn{S_{n}(t_i) = X^T W(t_i) X}, \mjseqn{W(t_i)} is the kernel weighted matrix. Details on
#' the computation of \mjseqn{S_n} could be found in \code{LocLinear} and its reference
gcv_cov <- function(bw, t, y, X, verbose = 1L) {
    .Call(`_mlrv_gcv_cov`, bw, t, y, X, verbose)
}

#' @export
#' @name MV_critical
#' @title Statistics-adapted values for extended minimum volatility selection.
#' @description  Calculation of the variance of the bootstrap statistics for the extended minimum volatility selection.
#' @param y, vector, as used in the Heter_LRV
#' @param data, list, a list of data
#' @param R, a cube of standard.normal random variables.
#' @param gridm, vector, a grid of candidate m's.
#' @param gridtau, vector, a grid of candidate tau's.
#' @param type, integer, 1 KPSS 2 RS 3 VS 4 KS
#' @param cvalue, double, 1-quantile for the calculation of bootstrap variance, default 0.1.
#' @param B, integer, number of iterations for the calculation of bootstrap variance
#' @param lrvmethod, integer, see also Heter_LRV
#' @param ind, integer, the type of kernel,  see also Heter_LRV
#' @param rescale, bool, whether to rescale when positiveness of the matrix is not obtained. default 0
#' @seealso Heter_LRV
#' @return a matrix of critical values
#' @examples
#' ###with Long memory parameter 0.2
#' param = list(d = -0.2, heter = 2,
#'  tvd = 0, tw = 0.8, rate = 0.1, cur = 1,
#'   center = 0.3, ma_rate =  0, cov_tw =  0.2,
#'   cov_rate = 0.1, cov_center = 0.1,
#'   all_tw  = 1, cov_trend = 0.7)
#' n = 1000
#' data = Qct_reg(n, param)
#' p = ncol(data$x)
#' t = (1:n)/n
#' B_c = 100 ##small value for testing
#' Rc = array(rnorm(n*p*B_c),dim = c(p,B_c,n))
#' result1 = LocLinear(0.2, t, data$y, data$x)
#' critical <- MV_critical(data$y, result1, Rc, c(3,4,5), c(0.2, 0.25, 0.3))
#' @references #' Bai, L., and Wu, W. (2023). Detecting long-range dependence for time-varying linear models. To appear in Bernoulli
MV_critical <- function(y, data, R, gridm, gridtau, type = 1L, cvalue = 0.1, B = 100L, lrvmethod = 1L, ind = 2L, rescale = 0L) {
    .Call(`_mlrv_MV_critical`, y, data, R, gridm, gridtau, type, cvalue, B, lrvmethod, ind, rescale)
}

#' @export
#' @name MV_ise_heter_critical
#' @title MV method
#' @description Selection of smoothing parameters for bootstrap tests by choosing the index minimizing the volatility of bootstrap statistics or long-run variance estimators in the neighborhood computed before.
#' @param critical, a matrix of critical values
#' @param neighbour, integer, number of neighbours
#' @return a list of results,
#' \itemize{
#' \item minp: optimal row number
#' \item minq: optimal column number
#' \item min_ise: optimal value
#' }
#' @examples
#' param = list(d = -0.2, heter = 2,
#'  tvd = 0, tw = 0.8, rate = 0.1,
#'  cur = 1, center = 0.3, ma_rate =  0,
#'  cov_tw =  0.2, cov_rate = 0.1,
#'  cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
#' n = 1000
#' data = Qct_reg(n, param)
#' p = ncol(data$x)
#' t = (1:n)/n
#' B_c = 100 ##small value for testing
#' Rc = array(rnorm(n*p*B_c),dim = c(p,B_c,n))
#' result1 = LocLinear(0.2, t, data$y, data$x)
#' gridm = c(3,4,5)
#' gridtau = c(0.2, 0.25, 0.3)
#' critical <- MV_critical(data$y, result1, Rc, gridm, gridtau)
#' mv_result = MV_ise_heter_critical(critical,  1)
#' m = gridm[mv_result$minp + 1]
#' tau_n = gridtau[mv_result$minq + 1]
#' @references  Bai, L., and Wu, W. (2023). Detecting long-range dependence for time-varying linear models. To appear in Bernoulli
MV_ise_heter_critical <- function(critical, neighbour) {
    .Call(`_mlrv_MV_ise_heter_critical`, critical, neighbour)
}

MV_ise_heter <- function(lrv_cub, dim, n, neighbour) {
    .Call(`_mlrv_MV_ise_heter`, lrv_cub, dim, n, neighbour)
}

MV_cov_heter <- function(e, X, gridm, gridtau, lrv_method = 0L, ind = 2L, ncp = 0L) {
    .Call(`_mlrv_MV_cov_heter`, e, X, gridm, gridtau, lrv_method, ind, ncp)
}

#' @export
#' @name MV_critical_cp
#' @title Statistics-adapted values for extended minimum volatility selection.
#' @description  Smoothing parameter selection for bootstrap tests for change point tests
#' @param y, vector, as used in the Heter_LRV
#' @param X, matrix, covariates
#' @param t, vector, time points.
#' @param gridm, vector, a grid of candidate m's.
#' @param gridtau, vector, a grid of candidate tau's.
#' @param cvalue, double, 1-quantile for the calculation of bootstrap variance, default 0.1.
#' @param B, integer, number of iterations for the calculation of bootstrap variance
#' @param lrvmethod, integer, see also Heter_LRV
#' @param ind, integer, the type of kernel,  see also Heter_LRV
#' @param rescale, bool, whether to rescale when positiveness of the matrix is not obtained. default 0
#' @return  a matrix of critical values
#' @examples
#' n = 300
#' t = (1:n)/n
#' data = bregress2(n, 2, 1) # time series regression model with 2 changes points
#' critical = MV_critical_cp(data$y, data$x,t,  c(3,4,5), c(0.2,0.25, 0.3))
#' @references  Bai, L., and Wu, W. (2023). Detecting long-range dependence for time-varying linear models. To appear in Bernoulli
MV_critical_cp <- function(y, X, t, gridm, gridtau, cvalue = 0.1, B = 100L, lrvmethod = 1L, ind = 2L, rescale = 0L) {
    .Call(`_mlrv_MV_critical_cp`, y, X, t, gridm, gridtau, cvalue, B, lrvmethod, ind, rescale)
}

Ctvfdiff <- function(x, d, burnin) {
    .Call(`_mlrv_Ctvfdiff`, x, d, burnin)
}

