% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_scores.R
\name{roc_scores}
\alias{roc_scores}
\title{ROC scores}
\usage{
roc_scores(preds, actuals)
}
\arguments{
\item{preds}{vector of predictions (need not be in range [0-1] - only order matters)}

\item{actuals}{vector of actuals - either logical or vector of 1s and 0s}
}
\description{
This function provides a way to identify the worst predictions when measuring Area Under the ROC curve. Simply
put, the worst predictions are the ones with very low or high relative prediction scores (usually probabilities) 
which relate to the positive and negative samples respectively.
}
\details{
How it works
\itemize{
\item{First the relative position (between 0 and 1) of each prediction is determined}
\item{Next the mean of actuals is determined}
\item{For samples whose position is on the correct side of the overall mean, 0 is given}
\item{For samples whose position is on the wrong side of the overall mean, its distance from the mean is given}
}
}
\examples{
roc_scores(c(1,2,3,4), actuals=c(1,1,0,0))
roc_scores(c(0.1, 0.2, 0.3, 0.4), actuals=c(TRUE, FALSE, TRUE, FALSE))

}
