% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulx.R
\name{simulx}
\alias{simulx}
\title{Simulation of mixed effects models and longitudinal data}
\usage{
simulx(model = NULL, group = NULL, treatment = NULL, parameter = NULL,
  output = NULL, data = NULL, project = NULL, settings = NULL,
  regressor = NULL, varlevel = NULL)
}
\arguments{
\item{model}{a \code{Mlxtran} or \code{PharmML} model used for the simulation}

\item{group}{a list, or a list of lists, with fields:
\itemize{
  \item \code{size} : size of the group (default=1),
  \item \code{level} : level(s) of randomization,
  \item \code{parameter} : if different parameters per group are defined,
  \item \code{output} : if different outputs per group are defined,
  \item \code{treatment} : if different treatements per group are defined,
  \item \code{regressor} : if different regression variables per group are defined.
}}

\item{treatment}{a list with fields
\itemize{
  \item \code{time} : a vector of input times,
  \item \code{amount} : a scalar or a vector of amounts,
  \item \code{rate} : a scalar or a vector of infusion rates (default=\code{Inf}),
  \item \code{tinf} : a scalar or a vector of infusion times (default=0),
  \item \code{type} : the type of input (default=1),
  \item \code{target} : the target compartment (default=NULL).
}}

\item{parameter}{a vector of parameters with their names and values}

\item{output}{a list (or list of lists) with fields:
\itemize{
  \item \code{name}: a vector of output names
  \item \code{time}: a vector of times (only for the longitudinal outputs)
}}

\item{data}{a list}

\item{project}{the name of a Monolix project}

\item{settings}{a list of optional settings
\itemize{
  \item \code{record.file} : name of the datafile where the simulated data is written (string),
  \item \code{seed} : initialization of the random number generator (integer),
  \item \code{load.design} : TRUE/FALSE (if load.design is not defined, a test is automatically performed to check if a new design has been defined),
  \item \code{data.in} : TRUE/FALSE (default=FALSE)
  \item \code{id.out}  : add columns id (when N=1) and group (when #group=1), TRUE/FALSE (default=FALSE)
  \item \code{Nmax} : maximum group size used in a single call of mlxCompute (default=100)
}}

\item{regressor}{a list, or a list of lists, with fields
\itemize{
  \item \code{name} : a vector of regressor names,
  \item \code{time} : a vector of times,
  \item \code{value} : a vector of values.
}}

\item{varlevel}{a list, or a list of lists, with fields
\itemize{
  \item \code{name} : a vector of names of variability levels,
  \item \code{time} : a vector of times that define the occasions.
}}
}
\value{
A list of data frames. Each data frame is an output of simulx
}
\description{
Compute predictions and sample data from \code{Mlxtran} and \code{PharmML} models
}
\details{
simulx takes advantage of the modularity of hierarchical models for simulating
different components of a model: models for population parameters, individual
covariates, individual parameters and longitudinal data.

Furthermore, \code{simulx} allows to draw different types of longitudinal data,
including continuous, count, categorical, and time-to-event data.

The models are encoded using either the model coding language \samp{Mlxtran} or the
markup language \samp{PharmML}. These models are automatically converted into C++ codes,
compiled on the fly and linked to R using the \samp{Rcpp} package.
That allows one to implement very easily complex models and to take advantage
of the numerical sovers used by the C++ \samp{MlxLibrary}.

See http://simulx.webpopix.org for more details.
}

