% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{refit_multiple_optimizers}
\alias{refit_multiple_optimizers}
\title{Refitting MMRM with Multiple Optimizers}
\usage{
refit_multiple_optimizers(fit, ..., control = mmrm_control(...))
}
\arguments{
\item{fit}{(\code{mmrm_fit})\cr original model fit from \code{\link[=fit_single_optimizer]{fit_single_optimizer()}}.}

\item{...}{Additional arguments passed to \code{\link[=mmrm_control]{mmrm_control()}}.}

\item{control}{(\code{mmrm_control})\cr object.}
}
\value{
The best (in terms of log likelihood) fit which converged.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\note{
For Windows, no parallel computations are currently implemented.
}
\examples{
fit <- fit_single_optimizer(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data,
  weights = rep(1, nrow(fev_data)),
  optimizer = "nlminb"
)
best_fit <- refit_multiple_optimizers(fit)
}
