# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Parameters of conditional multivariate normal distribution
#' @description This function calculates mean (expectation) and covariance 
#' matrix of conditional multivariate normal distribution.
#' @template param_mean_Template
#' @template param_sigma_Template
#' @template param_given_ind_Template
#' @template param_given_x_Template
#' @template param_dependent_ind_Template
#' @template param_is_validation_Template
#' @template param_is_names_Template
#' @template param_control_Template
#' @template param_n_cores_Template
#' @template details_cmnorm_Template
#' @template return_cmnorm_Template
#' @template example_cmnorm_Template
#' @export
cmnorm <- function(mean, sigma, given_ind, given_x, dependent_ind = numeric(), is_validation = TRUE, is_names = TRUE, control = NULL, n_cores = 1L) {
    .Call(`_mnorm_cmnorm`, mean, sigma, given_ind, given_x, dependent_ind, is_validation, is_names, control, n_cores)
}

#' Density of (conditional) multivariate normal distribution
#' @description This function calculates and differentiates density of 
#' (conditional) multivariate normal distribution.
#' @template param_x_Template
#' @template param_mean_Template
#' @template param_sigma_Template
#' @template param_given_ind_2_Template
#' @template param_log_Template
#' @template param_grad_x_Template
#' @template param_grad_sigma_Template
#' @template param_is_validation_Template
#' @template param_control_Template
#' @template param_n_cores_Template
#' @template details_dmnorm_Template
#' @template return_dmnorm_Template
#' @template example_dmnorm_Template
#' @references E. Kossova., B. Potanin (2018). 
#' Heckman method and switching regression model multivariate generalization.
#' Applied Econometrics, vol. 50, pages 114-143.
#' @export
dmnorm <- function(x, mean, sigma, given_ind = numeric(), log = FALSE, grad_x = FALSE, grad_sigma = FALSE, is_validation = TRUE, control = NULL, n_cores = 1L) {
    .Call(`_mnorm_dmnorm`, x, mean, sigma, given_ind, log, grad_x, grad_sigma, is_validation, control, n_cores)
}

#' Halton sequence
#' @description Calculate elements of the Halton sequence and of
#' some other pseudo-random sequences.
#' @param n positive integer representing the number of sequence elements.
#' @param base vector of positive integers greater then one representing
#' the bases for each of the sequences.
#' @param start non-negative integer representing the index of the first 
#' element of the sequence to be included in the output sequence.
#' @param random string representing the method of randomization to be
#' applied to the sequence. If \code{random = "NO"} (default) then
#' there is no randomization. If \code{random = "Tuffin"} then standard uniform
#' random variable will be added to each element of the sequence and 
#' the difference between this sum and it's 'floor' will be returned as
#' a new element of the sequence.
#' @param type string representing type of the sequence. Default is "halton"
#' that is Halton sequence. The alternative is "richtmyer" corresponding 
#' to Richtmyer sequence.
#' @param scrambler string representing scrambling method for the 
#' Halton sequence. Possible options are \code{"NO"} (default), \code{"root"}
#' and \code{"negroot"} which described in S. Kolenikov (2012).
#' @template param_is_validation_Template
#' @template param_n_cores_Template
#' @details Function \code{\link[mnorm]{seqPrimes}} could be used to
#' provide the prime numbers for the \code{base} input argument.
#' @return The function returns a matrix which \code{i}-th column
#' is a sequence with base \code{base[i]} and elements with indexes
#' from \code{start} to \code{start + n}.
#' @references J. Halton (1964) <doi:10.2307/2347972>
#' @references S. Kolenikov (2012) <doi:10.1177/1536867X1201200103>
#' @examples halton(n = 100, base = c(2, 3, 5), start = 10)
halton <- function(n = 1L, base = as.integer( c(2)), start = 1L, random = "NO", type = "halton", scrambler = "NO", is_validation = TRUE, n_cores = 1L) {
    .Call(`_mnorm_halton`, n, base, start, random, type, scrambler, is_validation, n_cores)
}

haltonSingleDraw <- function(ind = 1L, base = 2L, scrambler = "NO") {
    .Call(`_mnorm_haltonSingleDraw`, ind, base, scrambler)
}

#' Sequence of prime numbers
#' @description Calculates the sequence of prime numbers.
#' @param n positive integer representing the number of sequence elements.
#' @return The function returns a numeric vector containing 
#' first \code{n} prime numbers. The current (naive) implementation of the 
#' algorithm is not efficient in terms of speed so it is suited for low 
#' \code{n < 10000} but requires just O(n) memory usage.
#' @examples seqPrimes(10)
seqPrimes <- function(n) {
    .Call(`_mnorm_seqPrimes`, n)
}

#' Convert integer value to other base
#' @description Converts integer value to other base.
#' @param x positive integer representing the number to convert.
#' @param base positive integer representing the base.
#' @return The function returns a numeric vector containing 
#' representation of \code{x} in a base given in \code{base}.
#' @examples toBase(888, 5)
toBase <- function(x, base = 2L) {
    .Call(`_mnorm_toBase`, x, base)
}

#' Convert base representation of a number into integer
#' @description Converts base representation of a number into integer.
#' @param x vector of positive integer coefficients representing the number
#' in base that is \code{base}.
#' @param base positive integer representing the base.
#' @return The function returns a positive integer that is a
#' conversion from \code{base} under given coefficients \code{x}.
#' @examples fromBase(c(1, 2, 0, 2, 3), 5)
fromBase <- function(x, base = 2L) {
    .Call(`_mnorm_fromBase`, x, base)
}

#' Probabilities of (conditional) multivariate normal distribution
#' @description This function calculates and differentiates probabilities of
#' (conditional) multivariate normal distribution.
#' @template details_pmnorm_Template
#' @template param_lower_Template
#' @template param_upper_Template
#' @template param_given_x_Template
#' @template param_mean_Template
#' @template param_sigma_Template
#' @template param_given_ind_Template
#' @template param_n_sim_Template
#' @template param_method_Template
#' @template param_ordering_Template
#' @template param_log_Template
#' @template param_grad_lower_Template
#' @template param_grad_upper_Template
#' @template param_grad_sigma_pmnorm_Template
#' @template param_grad_given_Template
#' @template param_is_validation_Template
#' @template param_control_Template
#' @template param_n_cores_Template
#' @template param_marginal_Template
#' @template param_grad_marginal_Template
#' @template param_grad_marginal_prob_Template
#' @template return_pmnorm_Template
#' @template example_pmnorm_Template
#' @references Genz, A. (2004), Numerical computation of rectangular bivariate 
#' and trivariate normal and t-probabilities, Statistics and 
#' Computing, 14, 251-260.
#' @references Genz, A. and Bretz, F. (2009), Computation of Multivariate 
#' Normal and t Probabilities. Lecture Notes in Statistics, Vol. 195. 
#' Springer-Verlag, Heidelberg.
#' @references E. Kossova, B. Potanin (2018). 
#' Heckman method and switching regression model multivariate generalization.
#' Applied Econometrics, vol. 50, pages 114-143.
#' @references H. I. Gassmann (2003). 
#' Multivariate Normal Probabilities: Implementing an Old Idea of Plackett's.
#' Journal of Computational and Graphical Statistics, vol. 12 (3),
#' pages 731-752.
#' @export
pmnorm <- function(lower, upper, given_x = numeric(), mean = numeric(), sigma = matrix(), given_ind = numeric(), n_sim = 1000L, method = "default", ordering = "mean", log = FALSE, grad_lower = FALSE, grad_upper = FALSE, grad_sigma = FALSE, grad_given = FALSE, is_validation = TRUE, control = NULL, n_cores = 1L, marginal = NULL, grad_marginal = FALSE, grad_marginal_prob = FALSE) {
    .Call(`_mnorm_pmnorm`, lower, upper, given_x, mean, sigma, given_ind, n_sim, method, ordering, log, grad_lower, grad_upper, grad_sigma, grad_given, is_validation, control, n_cores, marginal, grad_marginal, grad_marginal_prob)
}

GHK <- function(lower, upper, sigma, h, ordering = "default", n_sim = 1000L, n_cores = 1L) {
    .Call(`_mnorm_GHK`, lower, upper, sigma, h, ordering, n_sim, n_cores)
}

#' Quantile function of a normal distribution
#' @description Calculate quantile of a normal distribution using
#' one of the available methods.
#' @param p numeric vector of values between 0 and 1 representing levels of
#' the quantiles.
#' @param mean numeric value representing the expectation of a
#' normal distribution.
#' @param sd positive numeric value representing standard deviation of a
#' normal distribution.
#' @param method character representing the method to be used for
#' quantile calculation. Available options are "Voutier" (default) and "Shore".
#' @template param_is_validation_Template
#' @template param_n_cores_Template
#' @details If \code{method = "Voutier"} then the method of P. Voutier (2010)
#' is used which maximum absolute error is about \eqn{0.000025}.
#' If \code{method = "Shore"} then the approach proposed
#' by H. Shore (1982) is applied which maximum absolute error is about
#' \eqn{0.026} for quantiles of level between \eqn{0.0001} 
#' and \eqn{0.9999}.
#' @return The function returns a vector of \code{p}-level quantiles of a
#' normal distribution with mean equal to \code{mean} and standard 
#' deviation equal to \code{sd}.
#' @references H. Shore (1982) <doi:10.2307/2347972>
#' @references P. Voutier (2010) <doi:10.48550/arXiv.1002.0567>
#' @examples qnormFast(c(0.1, 0.9), mean = 1, sd = 2)
qnormFast <- function(p, mean = 0L, sd = 1L, method = "Voutier", is_validation = TRUE, n_cores = 1L) {
    .Call(`_mnorm_qnormFast`, p, mean, sd, method, is_validation, n_cores)
}

#' Random number generator for (conditional) multivariate normal distribution
#' @description This function generates random numbers (i.e. variates) from 
#' (conditional) multivariate normal distribution.
#' @param n positive integer representing the number of random variates
#' to be generated from (conditional) multivariate normal distribution.
#' If \code{given_ind} is not empty vector then \code{n} should be
#' be equal to \code{nrow(given_x)}.
#' @template param_mean_Template
#' @template param_sigma_Template
#' @template param_given_ind_Template
#' @template param_given_x_Template
#' @template param_dependent_ind_Template
#' @template param_is_validation_Template
#' @template param_n_cores_Template
#' @details This function uses Cholesky decomposition to generate multivariate
#' normal variates from independent standard normal variates.
#' @template example_rmnorm_Template
#' @return This function returns a numeric matrix which rows a random variates
#' from (conditional) multivariate normal distribution with mean equal to
#' \code{mean} and covariance equal to \code{sigma}. If \code{given_x} and 
#' \code{given_ind} are also provided then random variates will be from
#' conditional multivariate normal distribution. Please, see details section
#' of \code{\link[mnorm]{cmnorm}} to get additional information on the 
#' conditioning procedure.
#' @export
rmnorm <- function(n, mean, sigma, given_ind = numeric(), given_x = numeric(), dependent_ind = numeric(), is_validation = TRUE, n_cores = 1L) {
    .Call(`_mnorm_rmnorm`, n, mean, sigma, given_ind, given_x, dependent_ind, is_validation, n_cores)
}

#' Differentiate Regularized Incomplete Beta Function.
#' @description Calculate derivatives of the regularized incomplete 
#' beta function that is a cumulative distribution function of the beta
#' distribution.
#' @param x numeric vector of values between 0 and 1. It is similar to
#' \code{q} argument of \code{\link[stats]{pbeta}} function.
#' @param p similar to \code{shape1} argument of 
#' \code{\link[stats]{pbeta}} function.
#' @param q similar to \code{shape2} argument of 
#' \code{\link[stats]{pbeta}} function.
#' @param n positive integer representing the number of iterations used
#' to calculate the derivatives. Greater values provide higher accuracy by the
#' cost of more computational resources.
#' @param is_validation logical; if \code{TRUE} then input arguments are
#' validated. Set to \code{FALSE} to slightly increase the performance
#' of the function.
#' @param control list of control parameters. Currently not intended 
#' for the users.
#' @details The function implements differentiation algorithm of 
#' R. Boik and J. Robinson-Cox (1998). 
#' Currently only first-order derivatives are considered.
#' @return The function returns a list which has the following elements:
#' \itemize{
#' \item \code{dx} - numeric vector of derivatives respect to each 
#' element of \code{x}.
#' \item \code{dp} - numeric vector of derivatives respect to \code{p} for
#' each element of \code{x}.
#' \item \code{dq} - numeric vector of derivatives respect to \code{q} for
#' each element of \code{x}.
#' }
#' @references Boik, R. J. and Robinson-Cox, J. F. (1998). Derivatives of the 
#' Incomplete Beta Function. Journal of Statistical Software, 3 (1),
#' pages 1-20.
#' @template example_pbetaDiff_Template
pbetaDiff <- function(x, p = 10, q = 0.5, n = 10L, is_validation = TRUE, control = NULL) {
    .Call(`_mnorm_pbetaDiff`, x, p, q, n, is_validation, control)
}

#' Standardized Student t Distribution
#' @name stdt
#' @description These functions calculate and differentiate a cumulative 
#' distribution function and density function of the standardized 
#' (to zero mean and unit variance) Student distribution. Quantile function 
#' and random numbers generator are also provided.
#' @param x numeric vector of quantiles.
#' @param df positive real value representing the number of degrees of freedom.
#' Since this function deals with standardized Student distribution, argument
#' \code{df} should be greater than \code{2} because otherwise variance is
#' undefined.
#' @param log logical; if \code{TRUE} then probabilities (or densities) p 
#' are given as log(p) and derivatives will be given respect to log(p).
#' @param grad_x logical; if \code{TRUE} then function returns a derivative
#' respect to \code{x}.
#' @param grad_df logical; if \code{TRUE} then function returns a derivative
#' respect to \code{df}.
#' @param n positive integer. If \code{rt0} function is used then this 
#' argument represents the number of random draws. Otherwise \code{n} states 
#' for the number of iterations used to calculate the derivatives associated 
#' with \code{pt0} function via \code{\link[mnorm]{pbetaDiff}} function.
#' @template details_t0_Template
#' @template return_t0_Template
#' @template example_t0_Template
dt0 <- function(x, df = 10, log = FALSE, grad_x = FALSE, grad_df = FALSE) {
    .Call(`_mnorm_dt0`, x, df, log, grad_x, grad_df)
}

#' @name stdt
#' @export
pt0 <- function(x, df = 10, log = FALSE, grad_x = FALSE, grad_df = FALSE, n = 10L) {
    .Call(`_mnorm_pt0`, x, df, log, grad_x, grad_df, n)
}

#' @name stdt
#' @export
rt0 <- function(n = 1L, df = 10) {
    .Call(`_mnorm_rt0`, n, df)
}

#' @name stdt
#' @export
qt0 <- function(x = 1L, df = 10) {
    .Call(`_mnorm_qt0`, x, df)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_mnorm_RcppExport_registerCCallable', PACKAGE = 'mnorm')
})
