% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmePredict_PS.R
\name{nlmePredict_PS}
\alias{nlmePredict_PS}
\title{Estimation of the print size value necessary to achieve a given reading speed.}
\usage{
nlmePredict_PS(nlme.model, reading.speed)
}
\arguments{
\item{nlme.model}{The object returned by \code{\link{nlmeModel}}}

\item{reading.speed}{A specific value of reading speed in words/minute}
}
\value{
The function returns a dataframe with a with two variables:
 \itemize{
  \item "reading_speed" -> the reading speed value passed to the function (in words/min)
  \item "required_print_size" -> the print size required to achieve the reading speed value passed to the function (in logMAR)
  }
}
\description{
This function uses results from the NLME model created with \code{\link{nlmeModel}} to estimate the print size value required to achieve a specific reading speed.
}
\section{Notes}{

The values of print size returned have been corrected for non-standard testing viewing distance.

For more details on the nlme fit, see:\\
Cheung SH, Kallie CS, Legge GE, Cheong AM. Nonlinear mixed-effects modeling of MNREAD data. 
Invest Ophthalmol Vis Sci. 2008;49:828–835. doi: 10.1167/iovs.07-0555.
}

\examples{
# inspect the structure of the dataframe
head(data_low_vision, 10)

#------

# restrict dataset to one MNREAD test per subject (regular polarity only)
data_regular <- data_low_vision \%>\%
    filter (polarity == "regular")

# run the NLME model for data grouped by subject
\dontrun{ nlme_model <- nlmeModel(data_regular, ps, vd, rt, err, subject) }

#------

# extract the critical print size required 
# to achieve 40 words/min (ie. spot reading) according to the NLME fit 
\dontrun{ nlmePredict_PS(nlme_model, 40) }

#------

# extract the critical print size required 
# to achieve 80 words/min (ie. fluent reading) according to the NLME fit 
\dontrun{ nlmePredict_PS(nlme_model, 80) }



}
\seealso{
\code{\link{nlmeModel}} to fit MNREAD data using a nonlinear mixed-effect (NLME) modeling

\code{\link{nlmeParam}} to estimate Maximum Reading Speed (MRS) and Critical Print Size (CPS) from the NLME model
 
\code{\link{nlmeCurve}} to plot the individual MNREAD curves estimated from the NLME model
}
