% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_bin.R
\name{manual_bin}
\alias{manual_bin}
\title{Binning based on cut points}
\usage{
manual_bin(df, yname, xname, cuts)
}
\arguments{
\item{df}{A input dataframe}

\item{yname}{The name string of Y with 0/1 binary values}

\item{xname}{The name string of X with numeric values}

\item{cuts}{A list of numeric values as cut points}
}
\value{
A summary dataframe
}
\description{
The function \code{manual_bin} implements the monotonic binning based on a list of cut points.
It is supposed to be a low level function called by various binning functions in the package.
}
\examples{
data(hmeq)
manual_bin(hmeq, "BAD", "DEROG", c(0, 1, 2))
}
