% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allclass.R, R/mobforest.output.R
\docType{class}
\name{mobforest.output-class}
\alias{mobforest.output-class}
\alias{get.pred.values,}
\alias{mobfores.output,}
\alias{logical,}
\alias{logical-method}
\alias{mobforest.output-method}
\alias{predictive.acc,}
\alias{mobforest.output,}
\alias{mobforest.output-method,}
\alias{show,mobforest.output-method}
\title{Class \code{"mobforest.output"} of mobforest model}
\usage{
\S4method{show}{mobforest.output}(object)
}
\arguments{
\item{object}{object of class \code{\linkS4class{mobforest.output}}}
}
\description{
Random Forest output for model based recursive partitioning
}
\section{Objects from the Class}{
 Objects can be created by
\code{\link{mobforest.output}}.
}

\examples{

\dontrun{
library(mlbench)
set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
BostonHousing <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]

# Recursive partitioning based on linear regression model medv ~ lstat with 3
# trees.  1 core/processor used. 
rfout <- mobforest.analysis(as.formula(medv ~ lstat), c("rad", "tax", "crim"),
    mobforest_controls = mobforest.control(ntree = 3, mtry = 2, replace = TRUE,
        alpha = 0.05, bonferroni = TRUE, minsplit = 25), data = BostonHousing,
    processors = 1, model = linearModel, seed = 1111)
}

}
\seealso{
\code{\linkS4class{prediction.output}},
\code{\linkS4class{varimp.output}}
}
\keyword{classes}
