% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stub.R
\name{stub}
\alias{stub}
\title{Replace a function with a stub.}
\usage{
stub(where, what, how)
}
\arguments{
\item{where}{Function to be called that will in turn call
\code{what}.}

\item{what}{Name of the function you want to stub out (a
\code{character} string).}

\item{how}{Replacement function (also a \code{\link{mock}} function)
or a return value for which a function will be created
automatically.}
}
\description{
The result of calling \code{stub} is that, when \code{where}
is invoked and when it internally makes a call to \code{what},
\code{how} is going to be called instead.
}
\details{
This is much more limited in scope in comparison to
\code{\link[testthat]{with_mock}} which effectively replaces
\code{what} everywhere. In other words, when using \code{with_mock}
and regardless of the number of intermediate calls, \code{how} is
always called instead of \code{what}. However, using this API,
the replacement takes place only for a single function \code{where}
and only for calls originating in that function.
}
\examples{
f <- function() TRUE
g <- function() f()
stub(g, 'f', FALSE)

# now g() returns FALSE because f() has been stubbed out
g()

}

