% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_crossings.R
\name{zero_crossings}
\alias{zero_crossings}
\alias{find_inversions}
\title{Find zero-crossings and inversion points}
\usage{
zero_crossings(x)

find_inversions(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
Vector of zero crossings or points of inversion.
}
\description{
Find zero crossings of a vector, i.e., indices when the numeric variable
crosses 0. It is useful for finding the points where a function changes by
looking at the zero crossings of its derivative.
}
\examples{
x <- sin(seq(0, 4 * pi, length.out = 100))
plot(x, type = "b")

zero_crossings(x)
find_inversions(x)
}
\seealso{
Based on the \code{uniroot.all} function from the rootSolve package.
}
