% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_slope.R
\name{threshold_slope}
\alias{threshold_slope}
\title{Estimates of threshold and slope for a fitted psychometric function}
\usage{
threshold_slope( pfit, xfit, thresh = 0.5 )
}
\arguments{
\item{pfit}{estimated values of the psychometric function}

\item{xfit}{stimulus levels at which the function was estimated}

\item{thresh}{criterion level at which to estimate threshold; default is 0.5}
}
\value{
\verb{x_th   } estimated threshold

\verb{slope  } estimated value of slope, i.e. derivative of pfit at x_th
}
\description{
This function finds the approximate value of x (=x_th) for which the value of the
estimated psychometric function is equal to 'thresh' and the approximate value of
slope in x_th.
}
\examples{
data("Miranda_Henson")
x = Miranda_Henson$x
r = Miranda_Henson$r
m = Miranda_Henson$m
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
# Find a plug-in bandwidth
bwd <- bandwidth_plugin( r, m, x)
pfit <- locglmfit( xfit, r, m, x, bwd )$pfit
prob <- 0.5 # Required threshold level
thr_sl <- threshold_slope( pfit, xfit, prob )

}
