% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/share_settings.R
\name{share_settings}
\alias{share_settings}
\title{Set shared settings of a model grid}
\usage{
share_settings(model_grid, ...)
}
\arguments{
\item{model_grid}{\code{model_grid}}

\item{...}{All optional shared settings.}
}
\value{
\code{model_grid} equipped with shared settings.
}
\description{
Set shared settings for all model (and training) configurations within a
model grid. These settings will apply for any given model, unless the same
settings have already been specified in the model specific configurations. In
that case, the model specific settings will apply.
}
\examples{
library(magrittr)
library(caret)
library(dplyr)
data(GermanCredit)

# Pre-allocate empty model grid.
models <- model_grid()

# Set shared settings of model grid.
models \%>\%
  share_settings(
    y = GermanCredit[["Class"]],
    x = GermanCredit \%>\% select(-Class),
    metric = "ROC",
    preProc = c("center", "scale", "pca"),
    trControl = trainControl(
      method = "cv",
      number = 5,
      summaryFunction = twoClassSummary,
      classProbs = TRUE
      )
  )
}
