% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{.opt}
\alias{.opt}
\alias{.sgd.opt}
\alias{.sgdwm.opt}
\alias{.adam.opt}
\title{Root R6 class representing a generic \code{optmiser}}
\description{
Root R6 class representing a generic \code{optmiser}

Root R6 class representing a generic \code{optmiser}

R6 class representing a SGD \code{optmiser}

R6 class representing a SGD \code{optmiser}

R6 class representing a SGDWM \code{optmiser}

R6 class representing a SGDWM \code{optmiser}

R6 class representing an Adam \code{optmiser}

R6 class representing an Adam \code{optmiser}
}
\details{
Object of this class are created by the '.modello'
session object that linkes them with the corresponding
\code{optimiser} in the FORTRAN environment.
}
\author{
Filippo Monari
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{.opt$new()}}
\item \href{#method-finalize}{\code{.opt$finalize()}}
\item \href{#method-name}{\code{.opt$name()}}
\item \href{#method-id}{\code{.opt$id()}}
\item \href{#method-pop}{\code{.opt$pop()}}
\item \href{#method-is.linked}{\code{.opt$is.linked()}}
\item \href{#method-print}{\code{.opt$print()}}
\item \href{#method-clone}{\code{.opt$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialise the reference object of class 'opt'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$new(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{number} name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Awares of a reference object associated
to an existing \code{number} is removed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\if{latex}{\out{\hypertarget{method-name}{}}}
\subsection{Method \code{name()}}{
Returns the name of the \code{optimiser}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the name of the \code{optmiser}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-id"></a>}}
\if{latex}{\out{\hypertarget{method-id}{}}}
\subsection{Method \code{id()}}{
Returns the id of the \code{optmiser}
(i.e. its position index in the \code{OPTS_} array).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$id()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the id of the optmiser
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pop"></a>}}
\if{latex}{\out{\hypertarget{method-pop}{}}}
\subsection{Method \code{pop()}}{
Pop (removes) the \code{optmiser} from the
\code{OPTS_} array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$pop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is.linked"></a>}}
\if{latex}{\out{\hypertarget{method-is.linked}{}}}
\subsection{Method \code{is.linked()}}{
Checks that the reference object is linked to
a \code{optmiser}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$is.linked()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Retursn TRUE if is linked, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints a representation of the \code{optmiser}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.opt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[modello:.opt]{modello::.opt}} -> \code{sgd.opt}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-step}{\code{.sgd.opt$step()}}
\item \href{#method-clone}{\code{.sgd.opt$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="finalize">}\href{../../modello/html/.opt.html#method-finalize}{\code{modello::.opt$finalize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="id">}\href{../../modello/html/.opt.html#method-id}{\code{modello::.opt$id()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="initialize">}\href{../../modello/html/.opt.html#method-initialize}{\code{modello::.opt$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="is.linked">}\href{../../modello/html/.opt.html#method-is.linked}{\code{modello::.opt$is.linked()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="name">}\href{../../modello/html/.opt.html#method-name}{\code{modello::.opt$name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="pop">}\href{../../modello/html/.opt.html#method-pop}{\code{modello::.opt$pop()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="print">}\href{../../modello/html/.opt.html#method-print}{\code{modello::.opt$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-step"></a>}}
\if{latex}{\out{\hypertarget{method-step}{}}}
\subsection{Method \code{step()}}{
Performs \code{niter} SGD steps
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.sgd.opt$step(g, j, lr, niter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{g}}{reference object of class 'graph'
containing the computational graph of the objective function}

\item{\code{j}}{refernence object of class 'number'
represeting the output of the objective function}

\item{\code{lr}}{learning rate}

\item{\code{niter}}{number of steps}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.sgd.opt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[modello:.opt]{modello::.opt}} -> \code{sgdwm.opt}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-step}{\code{.sgdwm.opt$step()}}
\item \href{#method-clone}{\code{.sgdwm.opt$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="finalize">}\href{../../modello/html/.opt.html#method-finalize}{\code{modello::.opt$finalize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="id">}\href{../../modello/html/.opt.html#method-id}{\code{modello::.opt$id()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="initialize">}\href{../../modello/html/.opt.html#method-initialize}{\code{modello::.opt$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="is.linked">}\href{../../modello/html/.opt.html#method-is.linked}{\code{modello::.opt$is.linked()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="name">}\href{../../modello/html/.opt.html#method-name}{\code{modello::.opt$name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="pop">}\href{../../modello/html/.opt.html#method-pop}{\code{modello::.opt$pop()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="print">}\href{../../modello/html/.opt.html#method-print}{\code{modello::.opt$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-step"></a>}}
\if{latex}{\out{\hypertarget{method-step}{}}}
\subsection{Method \code{step()}}{
Performs \code{niter} SGDWM steps
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.sgdwm.opt$step(g, j, lr, alpha, niter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{g}}{reference object of class 'graph'
containing the computational graph of the objective function}

\item{\code{j}}{refernence object of class 'number'
represeting the output of the objective function}

\item{\code{lr}}{learning rate}

\item{\code{alpha}}{momentum parameter}

\item{\code{niter}}{number of steps}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.sgdwm.opt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[modello:.opt]{modello::.opt}} -> \code{adam.opt}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-step}{\code{.adam.opt$step()}}
\item \href{#method-clone}{\code{.adam.opt$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="finalize">}\href{../../modello/html/.opt.html#method-finalize}{\code{modello::.opt$finalize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="id">}\href{../../modello/html/.opt.html#method-id}{\code{modello::.opt$id()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="initialize">}\href{../../modello/html/.opt.html#method-initialize}{\code{modello::.opt$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="is.linked">}\href{../../modello/html/.opt.html#method-is.linked}{\code{modello::.opt$is.linked()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="name">}\href{../../modello/html/.opt.html#method-name}{\code{modello::.opt$name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="pop">}\href{../../modello/html/.opt.html#method-pop}{\code{modello::.opt$pop()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic=".opt" data-id="print">}\href{../../modello/html/.opt.html#method-print}{\code{modello::.opt$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-step"></a>}}
\if{latex}{\out{\hypertarget{method-step}{}}}
\subsection{Method \code{step()}}{
Performs \code{niter} Adam steps
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.adam.opt$step(g, j, lr, beta1, beta2, niter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{g}}{reference object of class 'graph'
containing the computational graph of the objective function}

\item{\code{j}}{refernence object of class 'number'
represeting the output of the objective function}

\item{\code{lr}}{learning rate}

\item{\code{beta1}}{first order momentum parameter}

\item{\code{beta2}}{second order momentum parameter}

\item{\code{niter}}{number of steps}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.adam.opt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
