% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_df.R
\name{datasummary_df}
\alias{datasummary_df}
\title{Draw a table from a data.frame}
\usage{
datasummary_df(
  data,
  output = "default",
  fmt = 2,
  align = NULL,
  hrule = NULL,
  title = NULL,
  notes = NULL,
  add_rows = NULL,
  add_columns = NULL,
  ...
)
}
\arguments{
\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (character string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
  \item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "gt", "kableExtra", "huxtable", "flextable".
  \item Warning: the `output` argument \emph{cannot} be used when customizing tables with external packages. See the 'Details' section below.
}}

\item{fmt}{determines how to format numeric values
\itemize{
  \item integer: the number of digits to keep after the period `format(round(x, fmt), nsmall=fmt)`
  \item character: passed to the `sprintf` function (e.g., '\%.3f' keeps 3 digits with trailing zero). See `?sprintf`
  \item function: returns a formatted character string.
}}

\item{align}{A character string of length equal to the number of columns in
the table.  "lcr" means that the first column will be left-aligned, the 2nd
column center-aligned, and the 3rd column right-aligned.}

\item{hrule}{position of horizontal rules (integer vector)}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{...}{all other arguments are passed through to the extractor and
table-making functions. This allows users to specify additional options such
as set `broom::tidy(exponentiate=TRUE)` to exponentiate logistic regression
coefficients or `kableExtra::kbl(escape=FALSE)` to avoid escaping math
characters in `kableExtra` tables.}
}
\description{
Draw a table from a data.frame
}
