% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_modeltime_resamples.R
\name{plot_modeltime_resamples}
\alias{plot_modeltime_resamples}
\title{Interactive Resampling Accuracy Plots}
\usage{
plot_modeltime_resamples(
  .data,
  .metric_set = default_forecast_accuracy_metric_set(),
  .summary_fn = mean,
  ...,
  .facet_ncol = NULL,
  .facet_scales = "free_x",
  .point_show = TRUE,
  .point_size = 1,
  .point_shape = 16,
  .point_alpha = 1,
  .summary_line_show = TRUE,
  .summary_line_size = 0.5,
  .summary_line_type = 1,
  .summary_line_alpha = 1,
  .x_intercept = NULL,
  .x_intercept_color = "red",
  .x_intercept_size = 0.5,
  .legend_show = TRUE,
  .legend_max_width = 40,
  .title = "Resample Accuracy Plot",
  .x_lab = "",
  .y_lab = "",
  .color_lab = "Legend",
  .interactive = TRUE
)
}
\arguments{
\item{.data}{A modeltime table that includes a column \code{.resample_results} containing
the resample results. See \code{\link[=modeltime_fit_resamples]{modeltime_fit_resamples()}} for more information.}

\item{.metric_set}{A \code{yardstick::metric_set()} that is used to summarize
one or more forecast accuracy (regression) metrics.}

\item{.summary_fn}{A single summary function that is applied to aggregate the
metrics across resample sets. Default: \code{mean}.}

\item{...}{Additional arguments passed to the \code{.summary_fn}.}

\item{.facet_ncol}{Default: \code{NULL}. The number of facet columns.}

\item{.facet_scales}{Default: \code{free_x}.}

\item{.point_show}{Whether or not to show the individual points for each combination
of models and metrics. Default: \code{TRUE}.}

\item{.point_size}{Controls the point size. Default: 1.}

\item{.point_shape}{Controls the point shape. Default: 16.}

\item{.point_alpha}{Controls the opacity of the points. Default: 1 (full opacity).}

\item{.summary_line_show}{Whether or not to show the summary lines. Default: \code{TRUE}.}

\item{.summary_line_size}{Controls the summary line size. Default: 0.5.}

\item{.summary_line_type}{Controls the summary line type. Default: 1.}

\item{.summary_line_alpha}{Controls the summary line opacity. Default: 1 (full opacity).}

\item{.x_intercept}{Numeric. Adds an x-intercept at a location (e.g. 0). Default: NULL.}

\item{.x_intercept_color}{Controls the x-intercept color. Default: "red".}

\item{.x_intercept_size}{Controls the x-intercept size. Default: 0.5.}

\item{.legend_show}{Logical. Whether or not to show the legend.
Can save space with long model descriptions.}

\item{.legend_max_width}{Numeric. The width of truncation to apply to the legend text.}

\item{.title}{Title for the plot}

\item{.x_lab}{X-axis label for the plot}

\item{.y_lab}{Y-axis label for the plot}

\item{.color_lab}{Legend label if a \code{color_var} is used.}

\item{.interactive}{Returns either a static (\code{ggplot2}) visualization or an interactive (\code{plotly}) visualization}
}
\description{
A convenient plotting function for visualizing resampling accuracy by
resample set for each model in a Modeltime Table.
}
\details{
\strong{Default Accuracy Metrics}

The following accuracy metrics are included by default via \code{\link[modeltime:metric_sets]{modeltime::default_forecast_accuracy_metric_set()}}:
\itemize{
\item MAE - Mean absolute error, \code{\link[yardstick:mae]{yardstick::mae()}}
\item MAPE - Mean absolute percentage error, \code{\link[yardstick:mape]{yardstick::mape()}}
\item MASE  - Mean absolute scaled error, \code{\link[yardstick:mase]{yardstick::mase()}}
\item SMAPE - Symmetric mean absolute percentage error, \code{\link[yardstick:smape]{yardstick::smape()}}
\item RMSE  - Root mean squared error, \code{\link[yardstick:rmse]{yardstick::rmse()}}
\item RSQ   - R-squared, \code{\link[yardstick:rsq]{yardstick::rsq()}}
}

\strong{Summary Function}

Users can supply a single summary function (e.g. \code{mean}) to summarize the
resample metrics by each model.
}
\examples{

m750_training_resamples_fitted \%>\%
    plot_modeltime_resamples(
        .interactive = FALSE
    )


}
