% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-table.R
\name{combine_modeltime_tables}
\alias{combine_modeltime_tables}
\title{Combine multiple Modeltime Tables into a single Modeltime Table}
\usage{
combine_modeltime_tables(...)
}
\arguments{
\item{...}{Multiple Modeltime Tables (class \code{mdl_time_tbl})}
}
\description{
Combine multiple Modeltime Tables into a single Modeltime Table
}
\details{
This function combines multiple Modeltime Tables.
\itemize{
\item The \code{.model_id} will automatically be renumbered to ensure
each model has a unique ID.
\item Only the \code{.model_id}, \code{.model}, and \code{.model_desc} columns will be returned.
}

\strong{Re-Training Models on the Same Datasets}

One issue can arise if your models are trained on different datasets.
If your models have been trained on different datasets, you can run
\code{\link[=modeltime_refit]{modeltime_refit()}} to train all models on the same data.

\strong{Re-Calibrating Models}

If your data has been calibrated using \code{\link[=modeltime_calibrate]{modeltime_calibrate()}},
the \code{.test} and \code{.calibration_data} columns will be removed.
To re-calibrate, simply run \code{\link[=modeltime_calibrate]{modeltime_calibrate()}} on the newly
combined Modeltime Table.
}
\examples{
library(modeltime)
library(tidymodels)
library(tidyverse)
library(timetk)
library(lubridate)

# Setup
m750 <- m4_monthly \%>\% filter(id == "M750")

splits <- time_series_split(m750, assess = "3 years", cumulative = TRUE)

model_fit_arima <- arima_reg() \%>\%
    set_engine("auto_arima") \%>\%
    fit(value ~ date, training(splits))

model_fit_prophet <- prophet_reg() \%>\%
    set_engine("prophet") \%>\%
    fit(value ~ date, training(splits))

# Multiple Modeltime Tables
model_tbl_1 <- modeltime_table(model_fit_arima)
model_tbl_2 <- modeltime_table(model_fit_prophet)

# Combine
combine_modeltime_tables(model_tbl_1, model_tbl_2)

}
