% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-modeltime_table.R
\name{update_modeltime_model}
\alias{update_modeltime_model}
\title{Update the model by model id in a Modeltime Table}
\usage{
update_modeltime_model(object, .model_id, .new_model)
}
\arguments{
\item{object}{A Modeltime Table}

\item{.model_id}{A numeric value matching the .model_id that you want to update}

\item{.new_model}{A fitted workflow, model_fit, or mdl_time_ensmble object}
}
\description{
Update the model by model id in a Modeltime Table
}
\examples{
\donttest{
library(tidymodels)

model_fit_ets <- exp_smoothing() \%>\%
    set_engine("ets") \%>\%
    fit(value ~ date, training(m750_splits))

m750_models \%>\%
    update_modeltime_model(1, model_fit_ets)
}

}
\seealso{
\itemize{
\item \code{\link[=combine_modeltime_tables]{combine_modeltime_tables()}}: Combine 2 or more Modeltime Tables together
\item \code{\link[=add_modeltime_model]{add_modeltime_model()}}: Adds a new row with a new model to a Modeltime Table
\item \code{\link[=update_modeltime_description]{update_modeltime_description()}}: Updates a description for a model inside a Modeltime Table
\item \code{\link[=update_modeltime_model]{update_modeltime_model()}}: Updates a model inside a Modeltime Table
\item \code{\link[=pull_modeltime_model]{pull_modeltime_model()}}: Extracts a model from a Modeltime Table
}
}
