% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-nnetar_params.R
\name{nnetar_params}
\alias{nnetar_params}
\alias{num_networks}
\title{Tuning Parameters for NNETAR Models}
\usage{
num_networks(range = c(1L, 100L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Tuning Parameters for NNETAR Models
}
\details{
The main parameters for NNETAR models are:
\itemize{
\item \code{non_seasonal_ar}: Number of non-seasonal auto-regressive (AR) lags. Often denoted "p" in pdq-notation.
\item \code{seasonal_ar}: Number of seasonal auto-regressive (SAR) lags. Often denoted "P" in PDQ-notation.
\item \code{hidden_units}: An integer for the number of units in the hidden model.
\item \code{num_networks}: Number of networks to fit with different random starting weights. These are then averaged when producing forecasts.
\item \code{penalty}: A non-negative numeric value for the amount of weight decay.
\item \code{epochs}: An integer for the number of training iterations.
}
}
\examples{

num_networks()

}
\seealso{
\code{\link[=non_seasonal_ar]{non_seasonal_ar()}}, \code{\link[=seasonal_ar]{seasonal_ar()}}, \code{\link[dials:dropout]{dials::hidden_units()}}, \code{\link[dials:penalty]{dials::penalty()}}, \code{\link[dials:dropout]{dials::epochs()}}
}
