% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pennies.R
\docType{data}
\name{pennies_resamples}
\alias{pennies_resamples}
\title{Bootstrap resamples of a sample of 50 pennies}
\format{
A data frame of 1750 rows representing 35 students' bootstrap
resamples of size 50 and 3 variables
\describe{
  \item{replicate}{ID variable of replicate/resample number.}
  \item{name}{Name of student}
  \item{year}{Year on resampled penny}
}
}
\usage{
pennies_resamples
}
\description{
35 bootstrap resamples with replacement of sample of 50 pennies contained in
a 50 cent roll from Florence Bank on Friday February 1, 2019 in downtown Northampton,
Massachusetts, USA \url{https://goo.gl/maps/AF88fpvVfm12}. The original sample
of 50 pennies is available in \code{\link{pennies_sample}} .
}
\examples{
library(ggplot2)
library(dplyr)
bootstrap_sample_means <- pennies_resamples \%>\%
  group_by(name) \%>\%
  summarize(sample_mean = mean(year))

ggplot(bootstrap_sample_means, aes(x = sample_mean)) +
  geom_histogram(binwidth = 2.5) +
  labs(x = "sample mean year", title = "Bootstrap distribution of sample mean year")
}
\seealso{
\code{\link{pennies_sample}}
}
\keyword{datasets}
