% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{suggest_variable}
\alias{suggest_variable}
\title{Compare variables by importance.}
\usage{
suggest_variable(addTo, modelTag = NULL, sep = FALSE)
}
\arguments{
\item{addTo}{Summary list that contains model fits to compare.}

\item{modelTag}{Select model fits that contains modelTag on their name.}

\item{sep}{If TRUE, show variable importance results by each model fit.}
}
\value{
Plots of variable importance results from all available models.
}
\description{
\code{suggest_variable} Collect and compare variable importance metrics
if available.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]
sSummary <- list()
sSummary <- add_model(sSummary, x, y)
sSummary <- add_model(sSummary, x, y, model = c("C5.0Cost", "glmnet"), modelTag = "others")

suggest_variable(sSummary)

# vignette("modeval") #check a vignette for further details
}
}
