% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{suggest_probPop}
\alias{suggest_probPop}
\title{Compare class probability distributions based on the population.}
\usage{
suggest_probPop(addTo, outChar, predTag = "pred_test", modelTag = NULL)
}
\arguments{
\item{addTo}{Summary list that contains model fits to compare.}

\item{outChar}{A charactor value of output class name.}

\item{predTag}{Select prediction results that contains predTag on their name.}

\item{modelTag}{Select model fits that contains modelTag on their name.}
}
\value{
Plot indicating density distribution by observed population.
}
\description{
\code{suggest_probPop} Compare class probability distribution based on
the population of observations, sorted by probability values.
x-axis: percentile of class probability.
y-axis: observation density.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]
sSummary <- list()
sSummary <- add_model(sSummary, x, y)
sSummary <- add_model(sSummary, x, y, model = c("C5.0Cost", "glmnet"), modelTag = "others")
sSummary <- add_prob(sSummary, x_test, y_test, outChar = "pos")

suggest_probPop(sSummary, "pos")
suggest_probPop(sSummary, "pos", modelTag = "glm|svm")

# vignette("modeval") #check a vignette for further details
}
}
