% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_modsem_da.R
\name{compare_fit}
\alias{compare_fit}
\title{compare model fit for qml and lms models}
\usage{
compare_fit(estH0, estH1)
}
\arguments{
\item{estH0}{object of class `modsem_lms` or `modsem_qml` representing the
null hypothesis model}

\item{estH1}{object of class `modsem_lms` or `modsem_qml` representing the}
}
\description{
Compare the fit of two models using the likelihood ratio test.
`estH0` representing the null 
hypothesis model, and `estH1` the alternative hypothesis model. Importantly, 
the function assumes that `estH0` does not have more free parameters 
(i.e., degrees of freedom) than `estH1`.
alternative hypothesis model
}
\examples{
\dontrun{
H0 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z
"

estH0 <- modsem(m1, oneInt, "lms")

H1 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z + X:Z
"

estH1 <- modsem(m1, oneInt, "lms")
compare_fit(estH0, estH1)
}
}
