% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_modsem_da.R
\name{compare_fit}
\alias{compare_fit}
\title{compare model fit for qml and lms models}
\usage{
compare_fit(est_h0, est_h1)
}
\arguments{
\item{est_h0}{object of class `modsem_da` representing the
null hypothesis model}

\item{est_h1}{object of class `modsem_da` representing the}
}
\description{
Compare the fit of two models using the likelihood ratio test.
`est_h0` representing the null
hypothesis model, and `est_h1` the alternative hypothesis model. Importantly,
the function assumes that `est_h0` does not have more free parameters
(i.e., degrees of freedom) than `est_h1`.
alternative hypothesis model
}
\examples{
\dontrun{
m1 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z + X:Z
"

est_h1 <- modsem(m1, oneInt, "lms")
est_h0 <- estimate_h0(est_h1, calc.se=FALSE) # std.errors are not needed
compare_fit(est_h0, est_h1)
}
}
