% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plyClip.R
\name{plyClip}
\alias{plyClip}
\title{Clip a ply file}
\usage{
plyClip(
  plyFile,
  axis = "Z",
  vertIndex = NA,
  meshInvert = FALSE,
  button = "right",
  displayNew = TRUE,
  keepBoth = FALSE,
  edgeRefine = FALSE
)
}
\arguments{
\item{plyFile}{An object of classes 'mesh3d' and 'shape3d'}

\item{axis}{Logical indicating the axis plane on which to clip the mesh. May be "X", "Y", 
or "Z". Defaults to "Z".}

\item{vertIndex}{Numeric index of a ply vertex to define clipping plane. See Details.}

\item{meshInvert}{Logical indicating whether or not to invert the mesh about the 
user-indicated axis.}

\item{button}{Logical indicating which button on the mouse will select a region of the ply 
file. Must be one of 'right' (default), 'middle', or 'left'.}

\item{displayNew}{Logical indicating whether or not to display the ply file after clipping.}

\item{keepBoth}{Logical indicating whether or not to save both sides of the clipped ply.}

\item{edgeRefine}{Logical indicating whether or not to create a new, smooth edge along the 
indicated clipping plane.}
}
\description{
Function will clip a ply file along either the X, Y, or Z plane. The location for clipping 
can be indicated by the user through an interactive 3D window, or can be the index number 
of any vertex in the ply file.
}
\details{
This function returns a ply file that is clipped along a plane parallel to one of 
the three primary axes: X, Y, or Z. The location of the clipping plane is defined by one of 
the vertices in the ply file, and this 'focal vertex' is treated as a *minimum*. This means 
that regions of the ply file extending in a positive direction from the focal vertex along 
the user-defined axis (X, Y, or Z) will be retained as the user's selection, while regions 
of the negative to the focal vertex along the user-defined axis will be clipped out. The 
function offers two ways for the user to define the focal vertex: either by supplying an 
index number for a specific vertex in the ply file, or by allowing the user to interact 
with their ply in 3D and define a region of the ply in which to capture the focal vertex. 
It is assumed that most users will want to choose the region of their ply with the focal 
vertex, and the function therefore defaults to the interactive method unless a value is 
supplied for vertIndex.

When choosing the region with the focal vertex, a 3D interactive window displaying all ply 
vertices will appear. Users can manipulate this display with the left mouse button and 
zoom with the mouse wheel. The mouse button indicated by the button argument (defaults to 
'right') allows the user to define a rectangular region of space in which to identify the 
focal vertex. The focal vertex is calculated as that vertex in the user-selected region 
with the minimum value along the axis indicated by the user in the axis argument (defaults 
to 'Z' axis). The function will identify the focal vertex in the user-defined region and 
allow users an opportunity to re-select their region before clipping. If users find that 
the function is retaining the opposite region of interest from the one they were interested 
in (i.e., if they wish to select the region of the ply file *negative* to the focal vertex 
along their specified axis), then the meshInvert argument should be altered to TRUE.

The keepBoth parameter allows users to retain both the positive and negative sides of their 
original ply file, now separated into two distinct plys. If this option is enabled, the 
function will return a list containing two objects: a 'Positive' ply file representing the 
region of the surface the function would have returned by default, and a 'Negative' ply 
file representing the remainder portion of the surface. This argument cannot currently be 
enabled with the edgeRefine argument is enabled.

The edgeRefine parameter is intended to produce a smooth edge along the plane identified 
by the user. By default the function will only retain those vertices and faces that were 
positive to the focal vertex along the axis specified by the user. This often produces an 
irregular, jagged surface edge along the boundaries of the retained faces. Enabling the 
edgeRefine argument smooths this edge out by adding new vertices and faces to fill in the 
jagged areas, creating a surface boundary even with the focal vertex. Implementing this 
step for a mesh with a large number of faces (>50,000) may be time-intensive. This argument 
cannot currently be enabled when the keepBoth argument is enabled. NOTE: ENABLING 
edgeRefine WILL MAKE THE OUTPUT UNSUITABLE FOR CALCULATING RFI.

This function can be used to clip ply files representing mammal tooth surfaces in such a 
way as to retain only the area of the tooth crown above the lowest point of the occlusal 
basin. This cropping procedure is consistent with the one used to prepare surfaces for 
measurement of RFI by Ungar and M'Kirera (2003).

It is recommended that users clean their ply files with the molaR_Clean() function prior 
to using this function, as unreferenced vertices can cause errors when recreating ply 
files. Future implementations of this function will allow the keepBoth and edgeRefine 
arguments to be enabled simultaneously and will allow users to define arbitrary planes 
(rather than those parallel to the primary axes) for clipping ply files.
}
