% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/querries.R
\name{buildMgsFinal}
\alias{buildMgsFinal}
\title{buildMgsFinal
@date December 20th 2013}
\usage{
buildMgsFinal(genebag = NULL, mgs.cat, mgs.taxo, profiles, conn = TRUE,
  silent = TRUE, filt = 20)
}
\arguments{
\item{genebag}{: a vector of genes to be projected onto mgs or a list of genebags, default = NULL.}

\item{mgs.cat}{: MGS catalogue to be used}

\item{mgs.taxo}{: taxonomy table for the MGS catalogue}

\item{profiles}{:  the data profile matrix to extract the profiles}

\item{conn}{: if TRUE the connectivity of a group is to be computed and ordered, default = TRUE.}

\item{silent}{: print detailled information on progress, default = FALSE.}

\item{filt}{: filtering based on percentage of prevalence to avoid noise for no signal samples by
computeFilteredVectors.}
}
\value{
a list containing the final elements such as the 50 most connected genes, the mean vectors etc
}
\description{
This function will take a vector of genes (to be transformed into a list of genebags)
     or a list of genebags and will extract the profiles. Next genes well be ordered by connectivity
     which is to be computed for each group and the 50 most connected are selected to consitute the
     marker genes. These will be then used to compute the mean vectors. A final object containing all
     this information along with taxonomical annotation will be returned
}
\details{
\code{buildMgsFinal}
}
\author{
Edi Prifti
}

