% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/downsizing.R
\name{downsizeGC.all}
\alias{downsizeGC.all}
\title{downsizeGC.all}
\usage{
downsizeGC.all(data, levels = c(seq(1e+06, 1.1e+07, 1e+06)),
  repetitions = 10, silent = FALSE)
}
\arguments{
\item{data}{: raw read count matrix with gene_ids as rownames}

\item{levels}{: default seq(1E06,11E06,1E06), the downsizing levels number of reads to be selected randomly.}

\item{repetitions}{: default 10, the number of times the drawing is performed. Usually 30 or 10 to speed things out}

\item{silent}{: default is FALSE prints the status of downsizing}
}
\value{
a list of matrixes one per sample containing in rows a vector for each repetition and in columns the number of downsized genes for
       each downsizing level
}
\description{
This function takes a matrix with raw reads counts and computes the number of genes at different
downsizing levels a given number of times. This is similar to the downsizeGC function but for optimization purposes
it downsizes at different thresholds all together
}
\details{
\code{downsizeGC.all}
}
\note{
if the downsizing level is higher than the number of reads for a given sample than the result will be NA
}
\author{
Edi Prifti & Emmanuelle Le Chatelier
}

