% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.R
\name{text_tree}
\alias{text_tree}
\title{Implementation of Print Labels on MonoClust Tree}
\usage{
text_tree(
  x,
  which = 4,
  digits = getOption("digits") - 2,
  stats = TRUE,
  abbrev,
  cols = NULL,
  cols.type = c("l", "p", "b"),
  rel.loc.x = TRUE,
  show.pval = TRUE,
  uniform = FALSE,
  minbranch = 0.3,
  ...
)
}
\arguments{
\item{x}{MonoClust result object.}

\item{which}{Labeling modes, which are:
\itemize{
\item 1: only splitting variable names are shown, no splitting rules.
\item 2: only splitting rules to the left branches are shown.
\item 3: only splitting rules to the right branches are shown.
\item 4 (default): splitting rules are shown on both sides of branches.
}}

\item{digits}{Number of significant digits to print.}

\item{stats}{Whether to show statistics (cluster sizes and medoid points) on
the tree.}

\item{abbrev}{Whether to print the abbreviated versions of variable names.
Can be either "no" (default), "short", or "abbreviate". Short forms of them
can also be used.

If "no", the labels recorded in \code{x$labels} are used.

If "short", variable names will be turned into "V1", "V2", ...

If "abbreviate", \code{\link[=abbreviate]{abbreviate()}} function will be used. Use the optional
arguments for this function.}

\item{cols}{Whether to shown color bars at leaves or not. It helps matching
this tree plot with other plots whose cluster membership were colored. It
only works when \code{text} is \code{TRUE}. Either \code{NULL}, a vector of one color, or
a vector of colors matching the number of leaves.}

\item{rel.loc.x}{Whether to use the relative distance between clusters as x
coordinate of the leaves. Default is TRUE.}

\item{show.pval}{If MonClust object has been run through \code{\link[=perm.test]{perm.test()}},
whether to show p-value on the tree.}

\item{uniform}{If TRUE, uniform vertical spacing of the nodes is used; this
may be less cluttered when fitting a large plot onto a page. The default is
to use a non-uniform spacing proportional to the inertia in the fit.}

\item{minbranch}{Set the minimum length for a branch to \code{minbranch} times the
average branch length. This parameter is ignored if \code{uniform = TRUE}.
Sometimes a split will give very little improvement, or even no improvement
at all. A tree with branch lengths strictly proportional to improvement
leaves no room to squeeze in node labels.}

\item{...}{Extra arguments that would be transferred to \code{\link[graphics:text]{graphics::text()}}}
}
\value{
Labels on tree.
}
\description{
This function plots the labels onto the MonoClust tree. It is partially
inspired by rpart package.
}
\keyword{internal}
