% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.MonoClust.R
\name{plot.cv.MonoClust}
\alias{plot.cv.MonoClust}
\title{Plot the Mean Square Error with Error Bar for +/- 1 Standard Error}
\usage{
\method{plot}{cv.MonoClust}(
  x,
  main = "MSE for CV of monothetic clustering",
  xlab = "Number of clusters",
  ylab = "MSE +/- 1 SE",
  type = "b",
  lty = 2,
  err.col = "red",
  err.width = 0.1,
  ...
)
}
\arguments{
\item{x}{A \code{cv.MonoClust} object (output of \code{\link[=cv.test]{cv.test()}}).}

\item{main}{Overall title for the plot.}

\item{xlab}{Title for x axis.}

\item{ylab}{Title for y axis.}

\item{type}{What type of plot should be drawn. See \code{\link[graphics:par]{graphics::par()}}.}

\item{lty}{The line type.}

\item{err.col}{Color of the error bars.}

\item{err.width}{Width of the bars.}

\item{...}{Arguments to be passed to \code{\link[graphics:plot.default]{graphics::plot.default()}}.}
}
\value{
A line plot with error bars.
}
\description{
Plot the Mean Square Error with Error Bar for +/- 1 Standard Error
}
\examples{
\donttest{
library(cluster)
data(ruspini)

# 10-fold cross-validation
cptable <- cv.test(ruspini, minnodes = 2, maxnodes = 4)
plot(cptable)
}
}
\seealso{
Plot using ggplot2 \code{\link[=ggcv]{ggcv()}}
}
