% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotCircular.R
\name{plotCircular}
\alias{plotCircular}
\title{Circular plot}
\usage{
plotCircular(x, ancestor, col.lab, clade, LM, f = c(100, 0.1), sf = 1.5,
  ptscale = 1, tit = NULL)
}
\arguments{
\item{x}{a list containing objects that are matrices of average GPA coordinates for a set of
species. The names of this \code{x} contains should contain the species names}

\item{ancestor}{a matrix specifying the GPA coordinates of the root ancestor estimated
using the \code{fastAnc} function in the \code{phytools} package}

\item{col.lab}{a character vector specifying colors for species with matching indices in \code{x}}

\item{clade}{a character vector specifying the species that form a clade of interest; currently supports only two clades}

\item{LM}{the landmark of interest}

\item{f}{scaling factors for the magnitude of directional change}

\item{sf}{shrinking factor for \code{shrink argument} in \code{plot.circular} from the \code{circular} package}

\item{ptscale}{scaling factor for size of data point on the circle perimeter}

\item{tit}{title for the circular plot}
}
\description{
This function creates a circular plot (Batschelet, 1981) showing how mean directional change of GPA coordinates in species
of interest is distributed relative the root ancestor. Magnitude of directional change is proportional to the length of
ray projecting from a data point.
}
\details{
The arms in the circle are color-annotated according to clade of interest, with their direction and length indicating
mean directional and magnitude change in the clades of interest, respectively. The circular plot is a useful complement to the wireframe-lollipop
plot produced using \code{shapeEvo}, as it shows directional distribution details for all species at the individual landmark level. When
used in conjunction with the principal component loadings heat map produced using \code{pcloadhm}, it can greatly aid biological
interpretation of the principal components. This function depends on the \code{phytools} (Revell, 2012) and \code{circular} (Agostinelli & Lund, 2013) packages.
}
\examples{
library(circular)

data(va_mean)
data(estimated_ancestral_va)
data(spcolmap)

#the species in the defined clade infects the fish host Liza subviridis (dodger blue color)
plotCircular(va_mean, estimated_ancestral_va, col.lab=spcolmap$color,
clade=spcolmap[spcolmap$host \%in\% "L.subviridis",]$species, LM=6, tit=6)
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Agostinelli C, Lund U. (2013). R package 'circular': Circular Statistics (version 0.4-7). Available at: https://r-forge.r-project.org/projects/circular.

Batschelet E. (1981). Circular Statistics in Biology. London: Academic Press.

Khang TF, Soo OYM, Tan WB, Lim LHS. (2015). Monogenean anchor morphometry: systematic value, phylogenetic signal and evolution.

Revell LJ. (2012). phytools: An R package for phylogenetic comparative biology (and other things). Methods in Ecology and Evolution 3:217-223.
}
\seealso{
\code{\link{anglecheck}}, \code{\link{shapeEvo}}, \code{\link{pcloadhm}}
}

