% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shapeEvo.R
\name{shapeEvo}
\alias{shapeEvo}
\title{Statistical test of deviation from directional uniformity and estimation of average magnitude of directional change}
\usage{
shapeEvo(x, ancestor, col.lab = "black", coltones = redgreen(101), clade,
  exfac = 1, tit = NULL)
}
\arguments{
\item{x}{a list of objects that are matrices containing average GPA coordinates of anchor landmarks. The
species names should be the names of this list}

\item{ancestor}{a matrix specifying the GPA coordinates of the root ancestor, estimated
using \code{fastAnc} function in the \code{phytools} package}

\item{col.lab}{color for arrows in the wireframe-lollipop plot}

\item{coltones}{color tones for p-values; defaults to red-black-green spectrum}

\item{clade}{a character vector specifying the species that form a clade of interest}

\item{exfac}{an expansion factor for the magnitude of direction change}

\item{tit}{title for the wireframe-lollipop plot}
}
\value{
A wireframe-lollipop plot and a list containing:
\item{magnitude}{a matrix of the mean magnitude of directional change (column) of each landmark for each species (row)}
\item{pvalue}{p-values for each landmark from the Rayleigh test}
}
\description{
This function performs the Rayleigh test (Batschelet, 1981) for detecting deviation from
uniformity of directional change at each landmark. Additionally, it estimates the mean magnitude of directional change,
and then summarizes the result graphically using a wireframe-lollipop plot (Klingenberg, 2013).
}
\examples{
library(gplots)
library(circular)

data(va_mean)
data(estimated_ancestral_va)
data(spcolmap)

nf <- layout(matrix(c(1,1,1,2),1, 4,byrow=TRUE))
layout.show(nf)

cladeII <- spcolmap$species[spcolmap$host \%in\% "L.subviridis"]
shapeEvo(va_mean, estimated_ancestral_va, col.lab="dodgerblue",
clade=cladeII, exfac=2, tit="Ventral anchors")
#Some journals want the title to be left-adjusted, so set tit="" and then:
#title("a)", adj=0)

#Add a nice color bar
par(mar=c(5,6,4,2))
colorBar(redgreen(101),min=0, max=1, tit="p-value")
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Batschelet E. (1981). Circular Statistics in Biology. London: Academic Press.

Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.

Klingenberg CP. (2013). Visualizations in geometric morphometrics:
how to read and how to make graphs showing shape changes. Hystrix 24:15-24.
}
\seealso{
\code{\link{plotCircular}}, \code{\link{anglecheck}}
}

