% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tpColorPlot3d.R
\name{tpColorPlot3d}
\alias{tpColorPlot3d}
\title{Color-annotated three-dimensional scatter plot with transparency control}
\usage{
tpColorPlot3d(x, r = 0.005, phylo = FALSE, phy, labcol, xyzlabel = NULL,
  alpha.set = 0.2, mean.show = FALSE, asp = c(1, 1, 1))
}
\arguments{
\item{x}{a matrix with rows representing samples and columns representing three variables of
interest, typically principal components}

\item{r}{radius of plotting sphere}

\item{phylo}{if TRUE, coordinates of ancestral nodes from a supplied phylogeny (\code{phy}) are estimated using \code{fastAnc}
from the \code{phytools} package, and edges between nodes are joined according to the topology specified in \code{phy}}

\item{phy}{an object of class \code{phylo} from the \code{ape} package}

\item{labcol}{a character vector specifying species colors}

\item{xyzlabel}{a vector of characters specifying the titles for the xyz-axes}

\item{alpha.set}{a constant for controlling degree of transparency (0 for complete transparency; 1 for solid color) of the data points}

\item{mean.show}{if TRUE, the centroids of each species is plotted in solid color}

\item{asp}{a vector specifying the aspect ratio of the xyz axes; the default gives a cube}
}
\description{
This function enhances a three-dimensional scatter plot by enabling transparency control of
color annotation. In addition, it provides option for phylogenetic tree superimposition.
}
\details{
Transparency control of color-annotated data points reduces visual saturation caused by the use of solid colors for all
data points. Guide for choosing optimal value of \code{r}: for data range between -0.1 and 0.1, a value of 0.005 should be adequate.
If a phylogenetic tree is supplied, it may be superimposed onto the three-dimensional space to allow visualization of
evolutionary trajectories.
}
\examples{
library(phytools)
library(rgl)

data(ligophorus_shape)
data(ligotree)
data(spcolmap)

#Perform PCA of shape data for dorsal anchors and make 2D plots
pcashape <- pca2d(ligophorus_shape[,23:44], labcol=spcolmap$color,
phylo=TRUE, phy=ligotree, genus="L. ", bound.y=c(-0.08, 0.1),
bound.x1=c(-0.2,0.2), bound.x2 = c(-0.2,0.2))

#Check for proportion of variation explained by each PC
summary(pcashape$pca)

#A closer look with 3D plot
tpColorPlot3d(pcashape$scores[,3:1], r=0.005, phylo=TRUE, phy=ligotree, labcol=spcolmap$color,
xyzlabel=c("PC3 (8\%)","PC2 (10\%)","PC1 (61\%)"), mean.show=TRUE)
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.

Paradis E, Claude J & Strimmer K. (2004). APE: analyses of phylogenetics and evolution in R language. Bioinformatics 20: 289-290.

Revell LJ. (2012). phytools: An R package for phylogenetic comparative biology (and other things). Methods in Ecology and Evolution 3:217-223.
}
\seealso{
\code{\link{tpColorPlot2d}}
}

