% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonboot.R
\name{mboot.ci}
\alias{mboot.ci}
\title{m-Out-of-n Bootstrap Confidence Intervals}
\usage{
mboot.ci(boot.out, conf = 0.95, tau = NULL, types = "all", ...)
}
\arguments{
\item{boot.out}{The simulated bootstrap distribution from the \code{mboot} call.}

\item{conf}{The confidence level.}

\item{tau}{Function that returns its only argument applied to tau. If \code{NULL}, \code{estimate.tau} is used to estimate \code{tau}.}

\item{types}{The types of confidence intervals to be calculated. The value can be 'all' for all types, or a
subset of \code{c("basic", "norm", "sherman")}.}

\item{...}{When \code{tau} is omitted, the additional parameters are passed to \code{statistic} when estimating \code{tau}.}
}
\value{
A list of confidence intervals for the given types.
}
\description{
Estimates the confidence interval using the methods provided by \code{types}.
\code{tau} must be a function that calculates \code{tau.n} from its argument \code{n}.
If it is not provided, it is estimated with \code{estimate.tau} using the default settings of this function.
}
\details{
The additional parameters are passed to the statistic function if \code{tau} was omitted.
To specify the arguments of the \code{estimate.tau}, call this function directly and use its return value as \code{tau} argument.
For the type \code{sherman}, \code{tau} is not needed and is therefore not calculated.
}
\examples{
data <- runif(1000)
estimate.max <- function(data, indices) {return(max(data[indices]))}
tau <- \(x){x} # convergence rate
boot.out <- mboot(data, estimate.max, R = 1000, m = 2*sqrt(NROW(data)), replace = FALSE)
cis <- mboot.ci(boot.out, 0.95, tau, c("all"))
ci.basic <- cis$basic
print(ci.basic)

}
\references{
Politis D.N. and Romano J.P. (1994) Large sample confidence regions
based on subsamples under minimal assumptions \emph{The Annals of Statistics}, 22(4):2031-2050, doi:10.1214/aos/1176325770.

Sherman M. and Carlstein E. (2004) Confidence intervals based on estimators with unknown rates of convergence.
\emph{Computional statistics & data analysis}, 46(1):123-136.
}
\seealso{
mboot estimate.tau
}
\keyword{~htest}
