% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backgroundGrid.R
\name{delimit}
\alias{delimit}
\title{Delimit study area and background coordinates}
\usage{
delimit(bounding.coords, grid, names = NULL)
}
\arguments{
\item{bounding.coords}{A vector or a list of vectors with bounding coordinates in the following form: c(x1, x2, y1, y2). 
Also object returned by function \code{\link{boundingCoords}}.}

\item{grid}{SpatialPoints object}

\item{names}{Character. Names or IDs to be given to each shape. If not specified names of the object passed to 
bounding.coords will be given. In case this object has no names the background numbers will be used as names.}
}
\value{
A list with two components: 
\itemize{
 \item{polygons}{SpatialPolygons of the bounding boxes} 
 \item{xy}{list(s) of matrix(ces) of the background xy coordinates in columns}.
}
}
\description{
Creation of polygon shapes from bounding coordinates and delimitation of 
SpatialPoints data to the defined boundaries. This is an internal function used by function
\code{\link{backgroundGrid}}.
}
\details{
This function is aimed at restricting the study area inside the bounding boxes 
of a group of points (presences). The study area can be represented as a SpatialPoints 
object of a regular point grid, this grid also represents the background (excluding 
presences) from which pseudo-absences can be sampled. 
Ideally, this grid is extracted from the raster objects of the variables (centroids)
to be used for modelling, see \code{\link[raster]{xyFromCell}}, 
\code{\link[raster]{extract}} and example below. bbs.grid is the background inside 
bbs shapes.
}
\references{
Iturbide, M., Bedia, J., Herrera, S., del Hierro, O., Pinto, M., Gutierrez, J.M., 2015. 
A framework for species distribution modelling with improved pseudo-absence generation. Ecological 
Modelling. DOI:10.1016/j.ecolmodel.2015.05.018.
}
\author{
M. Iturbide
}
\keyword{internal}
